<?php
// components/Assistant/views/finish.php
if (!defined('BEEZUI_ROOT')) {
    // This file resides in <root>/components/Assistant/views
    define('BEEZUI_ROOT', dirname(dirname(dirname(__DIR__))));
}
require_once BEEZUI_ROOT . '/components/index.php';

use Components\Assistant\{State, FlowUtils};

[$flowId] = FlowUtils::resolveFlowAndYaml();
$stateKey = FlowUtils::stateKeyFor($flowId);
$state = State::get($stateKey);
// In a real app, persist $state['answers'] to DB. For now, clear session for this flow only.
State::clear($stateKey);

$inModal = true;
?>
<div class="max-w-2xl space-y-6">
  <div class="rounded-md border border-green-200 bg-green-50 p-4 text-green-900 dark:border-emerald-800/40 dark:bg-emerald-900/20 dark:text-emerald-200">
    <div class="font-semibold">You're all set!</div>
    <div class="text-sm mt-1">Thanks for completing the Assistant. You can adjust settings anytime in Configuration.</div>
  </div>
  <div class="flex items-center gap-3">
    <a href="#" hx-get="<?= \Components\Router::url('configuration', ['partial' => 1]) ?>" hx-target="#app-container" hx-swap="innerHTML" hx-push-url="?<?= \Components\Router::tabParam(); ?>=configuration"
       class="inline-flex items-center gap-2 rounded-md bg-brand-600 px-4 py-2 text-white hover:bg-brand-700">
      Go to Configuration
    </a>
    <?php if ($inModal): ?>
    <button type="button" command="close" commandfor="config-modal"
            class="inline-flex items-center gap-2 rounded-md border border-gray-300 bg-white px-4 py-2 text-gray-700 hover:bg-gray-50 dark:border-white/10 dark:bg-white/5 dark:text-gray-200 dark:hover:bg-white/10">
      Close
    </button>
    <?php endif; ?>
  </div>
</div>
