<?php
// components/Autoload.php
// Lightweight autoloader for the Components\ namespace (no Composer needed)

// Define project root constant (once)
if (!defined('BEEZUI_ROOT')) {
    // This file resides in <root>/components
    define('BEEZUI_ROOT', dirname(__DIR__));
}

// Define central app entrypoint used for all routed URLs
if (!defined('BEEZUI_ENTRYPOINT')) {
    define('BEEZUI_ENTRYPOINT', 'app.php');
}

spl_autoload_register(function ($class) {
    $prefix = 'Components\\';
    $baseDir = BEEZUI_ROOT . DIRECTORY_SEPARATOR . 'components' . DIRECTORY_SEPARATOR;

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return; // not our namespace
    }

    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', DIRECTORY_SEPARATOR, $relativeClass) . '.php';

    if (is_file($file)) {
        require_once $file;
    }
});
