<?php
// components/Card.php
namespace Components;

class Card extends Base
{
    public static function render(string $title, string $bodyHtml, ?string $icon = null, ?string $footerHtml = null, string $class = ''): string
    {
        $outer = ' bg-white border border-gray-200 rounded-lg';
        $classes = trim($outer . ' ' . $class);
        $titleEsc = self::h($title);

        ob_start();
        ?>
        <div class="<?= self::h($classes); ?>">
            <div class="p-4 flex flex-col items-start space-y-3 ">
                <div class="flex flex-row items-center space-x-2">
                    <?php if (!empty($icon)): ?>
                        <div class="flex items-center justify-center rounded-md bg-brand-500 text-brand-50 p-1 size-6">
                            <?= $icon ?>
                        </div>
                    <?php endif; ?>
                    <div class="text-sm font-semibold tracking-tight text-gray-900"><?= $titleEsc ?></div>
                </div>
                <?= $bodyHtml ?>
            </div>
            <?php if (!empty($footerHtml)): ?>
                <div class="px-4 pb-4"><?= $footerHtml ?></div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}
