<?php
namespace Components\Data\Contracts;

interface ConfigStoreProvider
{
    /**
     * Return full config map: module => values
     * @return array<string, array<string, mixed>>
     */
    public function getAllConfigs(): array;

    /**
     * Return module config values (assoc array); [] if none
     * @param string $module
     * @return array<string, mixed>
     */
    public function getModuleConfig(string $module): array;

    /**
     * Persist module config values
     * @param string $module
     * @param array<string, mixed> $values
     */
    public function setModuleConfig(string $module, array $values, bool $processOnlyGivenFields = false): void;

    /**
     * Return full status map derived from module_config: module => 'on'|''
     * @return array<string, string>
     */
    public function getAllStatuses(): array;

    /**
     * Return true if module is ON
     */
    public function isModuleOn(string $module): bool;

    /**
     * Set module status on/off, stored as *_STATUS inside module_config
     */
    public function setModuleStatus(string $module, bool $on): void;

    /**
     * UI open state map: module => bool
     * @return array<string, bool>
     */
    public function getUiOpenMap(): array;

    /**
     * Persist a single module UI open/closed state.
     */
    public function setUiOpenState(string $module, bool $open): void;

    /**
     * Optional: list known config keys for a module
     * @return array<int, string>
     */
    public function listKeys(string $module): array;
}
