<?php
namespace Components\Data\Contracts;

interface ModuleProvider
{
    /**
     * Return all modules in a flat list with common fields.
     * @return array<int, array<string,mixed>>
     */
    public function all(): array;

    /**
     * Return campaigns grouped by touchpoint.
     * @return array<string, array<int, array<string, mixed>>>
     */
    public function triggersByGroup(): array;

    /**
     * Return service modules grouped similarly to campaignsByGroup().
     * @return array<string, array<int, array<string, mixed>>>
     */
    public function serviceModulesByGroup(): array;

    /**
     * Return filter modules grouped similarly to campaignsByGroup().
     * @return array<string, array<int, array<string, mixed>>>
     */
    public function filterModulesByGroup(): array;

    /**
     * Return configuration modules grouped similarly to campaignsByGroup().
     * @return array<string, array<int, array<string, mixed>>>
     */
    public function configModulesByGroup(): array;

    /**
     * Return optional extensions available for a specific module.
     * @param string $module
     * @return array<int, array<string, mixed>>
     */
    public function extensions(string $module): array;

    /**
     * Human readable title for a module key.
     */
    public function title(string $key): ?string;

    /**
     * Whether the module exists.
     */
    public function exists(string $key): bool;
}
