<?php
namespace Components\Data\Contracts;

interface NavigationProvider
{
    /**
     * Return navigation menu groups for the sidebar.
     * Structure:
     * [
     *   [ 'header' => string, 'items' => [
     *       ['key'=>string,'label'=>string,'page'=>string,'submenu'=>?string,'icon'=>string]
     *   ]]
     * ]
     * @return array<int, array<string, mixed>>
     */
    public function groups(): array;

    /**
     * Resolve a navigation key from a page reference by consulting the provider's groups().
     * Supported inputs (case-insensitive):
     *  - "pages/foo.php"
     *  - "foo.php"
     *  - "foo" (basename without extension)
     * Returns an empty string when no matching item is found.
     */
    public function keyFromPage(string $page): string;

    /**
     * Given a navigation key (e.g., "dashboard"), return the CSS selector for the page's
     * primary HTMX target container.
     * By convention we use "#app-container-{key}". Implementations may override or look up
     * per-item configuration; when $key is empty fall back to "#app-container".
     */
    public function getTargetId(string $key): string;
}
