<?php
namespace Components\Data\Contracts;

/**
 * Provider for Newsletter Collections and Flows data used by the Newsletter UI.
 *
 * Expected shapes:
 * - collections(): array<int, array{id:int,slug:string,name:string,color:string,count:int}>
 * - flows(): array<int, array{id:int,name:string,collection_id:int,status:string,tags?:array<int,string>,start_date?:string|null,end_date?:string|null,target_list?:string|null}>
 */
interface NewsletterProvider
{
    /**
     * List of collections to display on the sidebar.
     * @return array<int, array<string, mixed>>
     */
    public function collections(): array;

    /**
     * List of flows used by the UI (will be filtered client-side by collection).
     * @return array<int, array<string, mixed>>
     */
    public function flows(): array;
}
