<?php
namespace Components\Data\Contracts;

/**
 * Provider for Template Coupons used by the Template Coupons page.
 *
 * Expected shape for each template:
 * - id: int|string (stable identifier)
 * - title: string
 * - desc: string
 * - tags?: array<int, string>
 * - badge?: string
 * - icon?: string (name or URL)
 */
interface TemplateCouponProvider
{
    /**
     * Return the list of available coupon templates.
     * @return array<int, array<string, mixed>>
     */
    public function templates($include_empty = true): array;
}
