<?php
namespace Components\Data\Live;

use Components\Data\Contracts\DatasourceProvider;

/**
 * Live provider for Datasources. Currently mirrors the mock provider.
 * Replace with DB/API integration when available.
 */
class LiveDatasourceProvider implements DatasourceProvider
{
    public function datasources(): array
    {
        return [
            [
                'key' => 'store_db',
                'title' => 'Store Database / Shop-Datenbank',
                'body_html' => '<p class="mt-1 text-sm text-gray-600">Direct access to all shop tables.<br><span class="text-gray-500">Direkter Zugriff auf alle Shop-Tabellen.</span></p>',
                'icon_svg' => '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-brand-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">'
                    . '<ellipse cx="12" cy="5" rx="9" ry="3"/>'
                    . '<path d="M3 5v14c0 1.7 4 3 9 3s9-1.3 9-3V5"/>'
                    . '<path d="M3 12c0 1.7 4 3 9 3s9-1.3 9-3"/>'
                    . '</svg>',
            ],
            [
                'key' => 'gambio_newsletter',
                'title' => 'Gambio Newsletter / Gambio Newsletter',
                'body_html' => '<p class="mt-1 text-sm text-gray-600">Use shop newsletter subscribers.<br><span class="text-gray-500">Verwendung der Shop-Newsletter-Abonnenten.</span></p>',
                'icon_svg' => '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-green-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">'
                    . '<path d="M16 21v-2a4 4 0 0 0-3-3.87"/>'
                    . '<path d="M12 3a4 4 0 1 1-4 4 4 4 0 0 1 4-4z"/>'
                    . '<path d="M8 21v-2a4 4 0 0 1 3-3.87"/>'
                    . '</svg>',
            ],
            [
                'key' => 'sitebeez_form',
                'title' => 'SiteBeez Form / SiteBeez-Formular',
                'body_html' => '<p class="mt-1 text-sm text-gray-600">Collect leads from SiteBeez forms.<br><span class="text-gray-500">Leads aus SiteBeez-Formularen sammeln.</span></p>',
                'icon_svg' => '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-orange-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">'
                    . '<rect x="3" y="4" width="18" height="4" rx="1"/>'
                    . '<rect x="3" y="12" width="9" height="4" rx="1"/>'
                    . '<rect x="12" y="12" width="9" height="4" rx="1"/>'
                    . '</svg>',
            ],
            [
                'key' => 'prospect_import',
                'title' => 'Prospect Import / Import von Interessenten',
                'body_html' => '<p class="mt-1 text-sm text-gray-600">Upload external contact lists.<br><span class="text-gray-500">Externe Kontaktlisten hochladen.</span></p>',
                'icon_svg' => '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-yellow-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">'
                    . '<path d="M12 3v12m0 0l-4-4m4 4l4-4"/>'
                    . '<path d="M20 21H4a2 2 0 0 1-2-2V7"/>'
                    . '</svg>',
            ],
            [
                'key' => 'api',
                'title' => 'API / API-Schnittstelle',
                'body_html' => '<p class="mt-1 text-sm text-gray-600">Connect external systems.<br><span class="text-gray-500">Externe Systeme anbinden.</span></p>',
                'icon_svg' => '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-purple-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">'
                    . '<path d="M12 2v4"/>'
                    . '<path d="M12 18v4"/>'
                    . '<path d="M4.93 4.93l2.83 2.83"/>'
                    . '<path d="M16.24 16.24l2.83 2.83"/>'
                    . '<path d="M2 12h4"/>'
                    . '<path d="M18 12h4"/>'
                    . '<path d="M4.93 19.07l2.83-2.83"/>'
                    . '<path d="M16.24 7.76l2.83-2.83"/>'
                    . '</svg>',
            ],
        ];
    }
}
