<?php
namespace Components\Data\Live;

use Components\Data\Contracts\FormDataProvider;

class LiveFormDataProvider implements FormDataProvider
{
    public function orderStatuses(): array
    {
        // Attempt to read via legacy beez_pro helper
        try {
            if (method_exists('beez_pro', 'getOrderStatus')) {
                $raw = \beez_pro::getOrderStatus(false);
                if (is_array($raw)) {
                    $opts = [];
                    foreach ($raw as $k => $v) {
                        if (is_int($k) || ctype_digit((string)$k)) {
                            $idx = (string)$k;
                            $id = (string)$v;
                            $labelKey = 'label' . $idx;
                            $label = isset($raw[$labelKey]) ? (string)$raw[$labelKey] : (string)$id;
                            $opts[$id] = $label;
                        }
                    }
                    if (!empty($opts)) {
                        return $opts;
                    }
                    // If not in legacy paired format, best-effort cast
                    $out = [];
                    foreach ($raw as $rk => $rv) {
                        if (is_scalar($rv)) {
                            $out[(string)$rk] = (string)$rv;
                        }
                    }
                    if (!empty($out)) return $out;
                }
            }
        } catch (\Throwable $e) {
            // ignore below and use an empty list
        }
        // No legacy available or failed; return empty array so callers may decide fallback
        return [];
    }
}
