<?php
namespace Components\Data\Mock;

use Components\Data\Contracts\NewsletterProvider;

class MockNewsletterProvider implements NewsletterProvider
{
    public function collections(): array
    {
        return [
            ['id'=>1,'slug'=>'all','name'=>'All','color'=>'#6b7280','count'=>6],
            ['id'=>2,'slug'=>'promotions','name'=>'Promotions','color'=>'#6366f1','count'=>3],
            ['id'=>3,'slug'=>'onboarding','name'=>'Onboarding','color'=>'#10b981','count'=>2],
            ['id'=>4,'slug'=>'seasonal','name'=>'Seasonal','color'=>'#f59e0b','count'=>1],
        ];
    }

    public function flows(): array
    {
        return [
            ['id'=>101,'name'=>'Welcome Series','collection_id'=>3,'status'=>'Active','tags'=>['welcome','series'],'start_date'=>'2025-09-20','end_date'=>'2025-10-20','target_list'=>'New Customers'],
            ['id'=>102,'name'=>'Black Friday Blast','collection_id'=>4,'status'=>'Draft','tags'=>['bfcm','promo'],'start_date'=>'2025-11-29','end_date'=>'2025-11-30','target_list'=>'All Subscribers'],
            ['id'=>103,'name'=>'Monthly Newsletter','collection_id'=>1,'status'=>'Active','tags'=>['news'],'start_date'=>'2025-09-01','end_date'=>'2025-12-01','target_list'=>'General Audience'],
            ['id'=>104,'name'=>'VIP Promotion','collection_id'=>2,'status'=>'Paused','tags'=>['vip','promo'],'start_date'=>'2025-09-10','end_date'=>'2025-09-30','target_list'=>'VIP Segment'],
            ['id'=>105,'name'=>'New Arrivals','collection_id'=>2,'status'=>'Active','tags'=>['catalog'],'start_date'=>'2025-09-15','end_date'=>'2025-10-15','target_list'=>'Shoppers Last 90 Days'],
            ['id'=>106,'name'=>'Winback Drip','collection_id'=>1,'status'=>'Active','tags'=>['reengage'],'start_date'=>'2025-09-22','end_date'=>'2025-10-22','target_list'=>'Inactive > 120 Days'],
        ];
    }
}
