<?php
// components/Form/Coupon.php
namespace Components\Form;

use Components\Base;

class Coupon extends BaseField
{
    /**
     * Render coupon templates using RichSelect as a scrollable dropdown with card-like options.
     * Each option includes icon, label (title), subheader (code), and description.
     *
     * @param array $options map of value => string
     */
    public static function render(string $name, string $label, array $options = [], $value = '', array $opts = []): string
    {

        $opts['include_empty'] = false;

        $flatOptions = [];
        foreach ($options as $key => $option) {
            $flatOptions[$key] = $option['label'];
        }

        return Select::render($name, $label, $flatOptions, $value, $opts);
    }
}
