<?php
// components/Form/I18nText.php
namespace Components\Form;

class I18nText extends BaseField {
    /**
     * Render multiple inputs (one per language) using mh_get_language_list().
     * $value is expected to be an array keyed by language_id -> string value.
     */
    public static function render(string $name, string $label, $value = [], array $opts = []): string {
        $errors = $opts['errors'] ?? [];
        $help = $opts['help'] ?? '';
        $hasError = !empty($errors);

        $nameEsc = self::h($name);
        $labelEsc = self::h($label);
        $helpHtml = self::helpHtml($help);
        $errorHtml = self::errorsHtml($errors);
        $badge = $opts['label_badge_html'] ?? '';

        // Languages source (live env provides mh_get_language_list)
        $langs = [];
        if (function_exists('mh_get_language_list')) {
            try { $langs = (array) \mh_get_language_list(); } catch (\Throwable $e) { $langs = []; }
        }
        if (empty($langs)) {
            $defaultId = function_exists('mh_cfg') ? (int)\mh_cfg('DEFAULT_LANGUAGE_ID', 1) : 1;
            $defaultCode = function_exists('mh_cfg') ? (string)\mh_cfg('DEFAULT_LANGUAGE_CODE', 'en') : 'en';
            $langs = [ [ 'id' => $defaultId, 'text' => 'Default', 'code' => $defaultCode ] ];
        }

        $values = is_array($value) ? $value : [];

        // Input-group classes (mirror Components\\Form\\Input)
        $groupBase = 'flex min-w-0 items-center rounded-md bg-white px-3 outline outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-brand dark:bg-white/5 dark:outline-white/10 dark:focus-within:outline-brand-500';
        $groupErr = $hasError ? ' outline-red-300 focus-within:outline-red-600 dark:outline-red-500/40 dark:focus-within:outline-red-500' : '';
        $groupClass = $groupBase . $groupErr;
        $groupInputClass = 'block min-w-0 grow bg-white py-1.5 pr-3 pl-1 text-base text-gray-900 placeholder:text-gray-400 focus:outline-none sm:text-sm/6 dark:bg-transparent dark:text-white dark:placeholder:text-gray-500';

        $rows = '';
        foreach ($langs as $lang) {
            if (!is_array($lang)) continue;
            $lid = (int)($lang['id'] ?? 0);
            if ($lid <= 0) continue;
            $lname = (string)($lang['text'] ?? ($lang['code'] ?? ''));
            $lcode = (string)($lang['code'] ?? '');
            $val = (string)($values[$lid] ?? '');
            $valEsc = self::h($val);
            $lidAttr = self::h((string)$lid);
            $lnameEsc = self::h($lname);
            $lnameEsc = '';
            $flag = self::flagIconHtml($lcode);
            $suffix = $flag !== '' ? ('<span class="inline-flex items-center gap-1">' . $flag . '</span>') : $lnameEsc;
            $rows .= <<<HTML
<div class="{$groupClass}">
  <input name="{$nameEsc}[{$lidAttr}]" type="text" value="{$valEsc}" class="{$groupInputClass}" />
  <div class="shrink-0 text-base text-gray-500 select-none sm:text-sm/6 dark:text-gray-400 opacity-70">{$suffix}</div>
</div>
HTML;
        }

        return <<<HTML
<div>
  <label class="block text-sm/6 font-medium text-gray-900 dark:text-white">{$labelEsc}{$badge}</label>
  <div class="mt-2 space-y-2">
    {$rows}
  </div>
  {$helpHtml}
  {$errorHtml}
</div>
HTML;
    }
}
