<?php
// components/Form/Presentation/ArrayPresenter.php

namespace Components\Form\Presentation;

class ArrayPresenter implements Presenter
{
    public static function render($value, array $def): string
    {
        $arr = is_array($value) ? $value : [];
        $text = implode(', ', array_map('strval', $arr));
        if ($text === '') { $text = \mh_lng('UI_EM_DASH','—'); }
        return \Components\Base::h($text);
    }
}
