<?php
// components/Form/Presentation/CouponPresenter.php

namespace Components\Form\Presentation;

class CouponPresenter implements Presenter
{
    public static function render($value, array $def): string
    {
        $id = (string)$value;
        if ($id === '') { return \Components\Base::h(\mh_lng('UI_EM_DASH','—')); }
        $tpl = null;
        try {
            $prov = \Components\Data\DataRegistry::templateCoupons();
            $rows = $prov ? $prov->templates() : [];
            foreach ((array)$rows as $row) {
                if (is_array($row) && (string)($row['id'] ?? '') === $id) { $tpl = $row; break; }
            }
        } catch (\Throwable $e) { $tpl = null; }



        $title = $tpl && isset($tpl['typeLabel']) ? (string)$tpl['typeLabel'] : $id;
        $desc = $tpl && isset($tpl['code']) ? (string)$tpl['code'] : '-';
        $label = \Components\Base::h($title);
        $subTitle = \Components\Base::h($desc);
        $icon = \Components\Base::SVG_VOUCHER;
        $html = <<<HTML
<div class="relative flex items-center bg-white ring ring-divider/70 shrink-0 text-left rounded-lg p-1.5 pr-3 space-x-2 leading-none" >
  <div class="relative flex items-center justify-center rounded-md size-8 p-1.5 bg-orange-100 text-orange-600">{$icon}</div>
  <div class="flex flex-col justify-between min-w-0 h-8 pt-0.5  ">
    <p class="text-secondary text-[11px]">{$subTitle}</p>
    <p class="text-primary text-xs font-medium  truncate max-w-[12rem]">{$label}</p>
  </div>
</div>
HTML;
        return $html;
    }
}
