<?php
// components/Form/Presentation/ValuePresenter.php
// Dispatcher presenter that delegates to specialized presenters for display logic

namespace Components\Form\Presentation;

class ValuePresenter
{
    /**
     * Render a configuration value for display based on its field definition
     */
    public static function render($value, array $def): string
    {

        $type = strtolower((string)($def['type'] ?? 'input'));
        $vType = strtolower((string)($def['validate']['type'] ?? ''));

        // Coupon card
        if ($type === 'coupon') {
            return CouponPresenter::render($value, $def);
        }

        // Arrays (e.g., multi-select)
        if (is_array($value)) {
            if ($type === 'order_status_multiple') {
                return OrderStatusMultiplePresenter::render($value, $def);
            }
            return ArrayPresenter::render($value, $def);
        }

        // Booleans
        if ($type === 'toggle' || $type === 'checkbox' || $vType === 'boolean') {
            return BoolPresenter::render($value, $def);
        }

        // Delay days
        if ($type === 'delay_days') {
            return DelayDaysPresenter::render($value, $def);
        }

        // Order status multiple (CSV string)
        if ($type === 'order_status_multiple') {
            return OrderStatusMultiplePresenter::render($value, $def);
        }

        // Default string rendering
        return DefaultPresenter::render($value, $def);
    }
}
