<?php
// components/Form/RichSelect.php
namespace Components\Form;

class RichSelect extends BaseField {
    /**
     * @param array $options map of value => [label=>..., description=>...]
     */
    public static function render(string $name, string $label, array $options = [], $value = '', array $opts = []): string {
        $errors = $opts['errors'] ?? [];
        $help = $opts['help'] ?? '';
        $extra = $opts['input_attrs'] ?? '';
        $hasError = !empty($errors);

        $nameEsc = self::h($name);
        $labelEsc = self::h($label);

        // Build options normalized structure
        $normalized = [];
        foreach ($options as $val => $def) {
            if (is_array($def)) {
                $text = (string)($def['label'] ?? $def['text'] ?? $val);
                $desc = (string)($def['description'] ?? $def['desc'] ?? '');
            } else {
                $text = (string)$def;
                $desc = '';
            }
            $normalized[] = [
                'value' => (string)$val,
                'label' => $text,
                'description' => $desc,
            ];
        }

        // Determine selected label for header
        $selectedLabel = '';
        foreach ($normalized as $opt) {
            if ((string)$opt['value'] === (string)$value) {
                $selectedLabel = $opt['label'];
                break;
            }
        }
        if ($selectedLabel === '') {
            // fallback to first option label or placeholder
            $selectedLabel = $normalized[0]['label'] ?? 'Select';
        }

        $helpHtml = self::helpHtml($help);
        $errorHtml = self::errorsHtml($errors);
        $valueEsc = self::h((string)$value);
        $badge = $opts['label_badge_html'] ?? '';

        // Build <el-option> list
        $optsHtml = '';
        foreach ($normalized as $opt) {
            $v = self::h($opt['value']);
            $t = self::h($opt['label']);
            if ($opt['description'] !== '') {
            $descEsc = self::h($opt['description']);
            $d = <<<HTML
<p class="mt-2 text-gray-500 group-focus/option:text-brand-200 in-[el-selectedcontent]:hidden dark:text-gray-400 dark:group-focus/option:text-brand-100">{$descEsc}</p>
HTML;
            } else { $d = ''; }
            $optsHtml .= <<<HTML
    <el-option value="{$v}" class="group/option block cursor-default p-4 text-sm text-gray-900 select-none focus:bg-brand-700 focus:text-white focus:outline-hidden dark:text-white dark:focus:bg-brand-600">
      <div class="flex flex-col">
        <div class="flex justify-between">
          <p class="font-normal group-aria-selected/option:font-semibold in-[el-selectedcontent]:font-semibold">{$t}</p>
          <span class="text-brand-700 group-not-aria-selected/option:hidden group-focus/option:text-white in-[el-selectedcontent]:hidden dark:text-brand-400">
            <svg viewBox="0 0 20 20" fill="currentColor" data-slot="icon" aria-hidden="true" class="size-5">
              <path d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z" clip-rule="evenodd" fill-rule="evenodd" />
            </svg>
          </span>
        </div>
        {$d}
      </div>
    </el-option>
HTML;
        }

        // Selected header content label
        $selectedEsc = self::h($selectedLabel);

        // Note: we keep name/value on <el-select> so it posts like a normal select
        return <<<HTML
<div>
<label class="block">
  <span class="text-sm text-gray-700">{$labelEsc}{$badge}</span>
  <el-select name="{$nameEsc}" value="{$valueEsc}" {$extra}>
    <div class="inline-flex divide-x divide-brand-700 rounded-md outline-hidden dark:divide-brand-600">
      <div class="inline-flex items-center gap-x-1.5 rounded-l-md bg-brand-700 px-3 py-2 text-white dark:bg-brand-600">
        <svg viewBox="0 0 20 20" fill="currentColor" data-slot="icon" aria-hidden="true" class="-ml-0.5 size-5">
          <path d="M16.704 4.153a.75.75 0 0 1 .143 1.052l-8 10.5a.75.75 0 0 1-1.127.075l-4.5-4.5a.75.75 0 0 1 1.06-1.06l3.894 3.893 7.48-9.817a.75.75 0 0 1 1.05-.143Z" clip-rule="evenodd" fill-rule="evenodd" />
        </svg>
        <el-selectedcontent class="text-sm font-semibold">{$selectedEsc}</el-selectedcontent>
      </div>
      <button type="button" aria-label="Change selection" class="inline-flex items-center rounded-l-none rounded-r-md bg-brand p-2 hover:bg-brand-800 focus-visible:outline-2 focus-visible:outline-brand-400 dark:bg-brand-600 dark:hover:bg-brand-500 dark:focus-visible:outline-brand-400">
        <svg viewBox="0 0 20 20" fill="currentColor" data-slot="icon" aria-hidden="true" class="size-5 text-white forced-colors:text-[Highlight]">
          <path d="M5.22 8.22a.75.75 0 0 1 1.06 0L10 11.94l3.72-3.72a.75.75 0 1 1 1.06 1.06l-4.25 4.25a.75.75 0 0 1-1.06 0L5.22 9.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd" fill-rule="evenodd" />
        </svg>
      </button>
    </div>

    <el-options anchor="bottom end" popover class="w-72 origin-top-right divide-y divide-gray-200 overflow-hidden rounded-md bg-white shadow-lg outline-1 outline-black/5 [--anchor-gap:--spacing(2)] data-leave:transition data-leave:transition-discrete data-leave:duration-100 data-leave:ease-in data-closed:data-leave:opacity-0 dark:divide-white/10 dark:bg-gray-800 dark:shadow-none dark:-outline-offset-1 dark:outline-white/10">
{$optsHtml}
    </el-options>
  </el-select>
  {$helpHtml}
  {$errorHtml}
</label>
</div>
HTML;
    }
}
