<?php
namespace Components\Models;

class NewsletterCampaign extends BaseModel
{
    protected static string $table = 'TABLE_MAILBEEZ_NEWSLETTER_CAMPAIGNS';
    protected static string $primaryKey = 'newsletter_campaign_id';

    protected static string $blueprint = 'newsletter_campaign.yaml';

    /**
     * Relation: a campaign has many newsletter items (default/root items only)
     * Returns only items of type ITEM_TYPE_DEFAULT (excludes follow-up items).
     * @return array<NewsletterItem>
     */
    public function items(): array
    {
        // Fetch all related items, then filter out follow-ups
        $all = $this->hasMany(NewsletterItem::class, 'newsletter_campaign_id');
        if (!$all) { return []; }

        // Only include items with type ITEM_TYPE_DEFAULT (exclude follow-ups)
        $filtered = array_filter($all, function ($item) {
            return $item instanceof NewsletterItem && $item->isInitial();
        });

        // Reindex array to have sequential numeric keys
        return array_values($filtered);
    }
}
