<?php
// Enable verbose PHP error output for development (local test only)
@ini_set('display_errors', '1');
@ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Define project root constant if not already defined
if (!defined('BEEZUI_ROOT')) {
    define('BEEZUI_ROOT', __DIR__);
}

// index.php is a simple local test harness that includes wrapper.php.
// The reusable iframe loader lives in wrapper.php, which is intended to be included by the real project.
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>MailBeez UI Container</title>
    <style>
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
        }
        body {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
            color: #0f172a;
        }
        header {
            padding: 12px 16px;
            border-bottom: 1px solid #e2e8f0;
            background: #f8fafc;
        }
        .container {
            /* This div encapsulates the iframe and grows to fill remaining space */
            flex: 1 1 auto;
            min-height: 0; /* important so child with height:100% can size correctly in flexbox */
            display: flex;
            flex-direction: column;
        }
        .frame-wrap {
            position: relative;
            width: 100%;
            height: 100%;
            flex: 1 1 auto;
            min-height: 0;
            overflow: hidden;
            background: #ffffff;
        }
        iframe.fullsize {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0;
        }
    </style>
</head>
<body>
    <header>
        <h1 style="margin:0; font-size: 18px;">MailBeez Admin UI</h1>
    </header>

    <div class="container">
        <?php include BEEZUI_ROOT . '/wrapper.php'; ?>
    </div>
</body>
</html>
