<?php
// pages/components/config_modal_docs.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';

use Components\Button;

ob_start();
?>
<div class="prose max-w-none dark:prose-invert">
  <h1 class="text-2xl font-semibold">Config Modal Documentation</h1>
  <p class="text-gray-600 dark:text-gray-300">The global modal component <code>#config-modal</code> lets you show configuration or info content either loaded via HTMX into the modal body or as an isolated URL inside an iframe. It is available on all pages (included once in the app frame).</p>

  <h2 class="text-xl font-semibold mt-6">How to open</h2>
  <p>Add a trigger element with <code>command="show-modal"</code> and <code>commandfor="config-modal"</code>. You can then control content and appearance using data attributes shown below.</p>

  <h3 class="text-lg font-semibold mt-4">Attributes</h3>
  <ul class="list-disc ml-5">
    <li><code>data-title</code>: Optional title. If omitted, the header is hidden and a floating close button is shown.</li>
    <li><code>data-close-button</code>: Show the close button. Values: <code>true</code> (default) or <code>false</code>. Applies to header or floating close depending on title.</li>
    <li><code>data-size</code>: Size preset for width/behavior. One of <code>sm</code>, <code>md</code>, <code>lg</code>, <code>xl</code>, <code>2xl</code>, <code>3xl</code>, <code>4xl</code>, <code>5xl</code>, <code>6xl</code>, <code>full</code>, <code>full-margin</code>. Default <code>2xl</code>.</li>
    <li><code>data-width</code> and <code>data-heigth</code> (also accepts <code>data-height</code>): Inline width/height (e.g. <code>800px</code>, <code>70vh</code>) that override the size preset when provided.</li>
    <li><code>data-url</code>: When set, the modal shows an iframe with this URL. A loading overlay is displayed until the content has loaded.</li>
  </ul>

  <h3 class="text-lg font-semibold mt-4">Loading content with HTMX</h3>
  <p>Omit <code>data-url</code> and use HTMX on the trigger to load into <code>#config-modal-body</code>:</p>
  <pre class="bg-gray-900 text-gray-100 p-3 rounded"><code>&lt;button
  command="show-modal" commandfor="config-modal"
  data-title="Edit Settings" data-size="3xl"
  hx-get="<?= BEEZUI_ENTRYPOINT ?>?page=module_config&amp;partial=1"
  hx-target="#config-modal-body" hx-swap="innerHTML"&gt;Open HTMX Modal&lt;/button&gt;</code></pre>

  <div class="mt-2">
    <?php
    echo Button::render('Demo: HTMX content', [
        'variant' => 'secondary',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'HTMX Demo',
            'data-size' => '3xl',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
  </div>

  <h3 class="text-lg font-semibold mt-6">Loading an external URL (iframe)</h3>
  <p>Set <code>data-url</code> to switch to iframe mode. A loading overlay will be shown until the content is ready.</p>
  <pre class="bg-gray-900 text-gray-100 p-3 rounded"><code>&lt;button
  command="show-modal" commandfor="config-modal"
  data-title="Docs in Iframe" data-size="4xl"
  data-url="../external_modal.php"&gt;Open Iframe Modal&lt;/button&gt;</code></pre>

  <div class="mt-2">
    <?php
    echo Button::render('Demo: Iframe content', [
        'variant' => 'secondary',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'Iframe Demo',
            'data-size' => '4xl',
            'data-url' => '../external_modal.php',
        ],
    ]);
    ?>
  </div>

  <h3 class="text-lg font-semibold mt-6">Sizing options</h3>
  <p>Use a preset via <code>data-size</code> or exact dimensions via <code>data-width</code> and <code>data-heigth</code>/<code>data-height</code>.</p>
  <pre class="bg-gray-900 text-gray-100 p-3 rounded"><code>&lt;button command="show-modal" commandfor="config-modal" data-title="Small" data-size="sm"&gt;Small&lt;/button&gt;
&lt;button command="show-modal" commandfor="config-modal" data-title="Full" data-size="full"&gt;Fullscreen&lt;/button&gt;
&lt;button command="show-modal" commandfor="config-modal" data-title="Full with margin" data-size="full-margin"&gt;Fullscreen with margin&lt;/button&gt;
&lt;button command="show-modal" commandfor="config-modal" data-title="Custom" data-width="880px" data-height="70vh"&gt;Custom size&lt;/button&gt;</code></pre>
  <div class="mt-2 flex flex-wrap gap-2">
    <?php
    echo Button::render('Small', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'Small Modal',
            'data-size' => 'sm',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    echo Button::render('Full', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'Fullscreen',
            'data-size' => 'full',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    echo Button::render('Full with margin', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'Fullscreen with Margin',
            'data-size' => 'full-margin',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    echo Button::render('Custom size', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'Custom Dimensions',
            'data-width' => '880px',
            'data-height' => '70vh',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
  </div>

  <h3 class="text-lg font-semibold mt-6">Header and close button</h3>
  <ul class="list-disc ml-5">
    <li>No <code>data-title</code> = header hidden, floating close button shown.</li>
    <li>Set <code>data-close-button="false"</code> to hide the close button entirely (use ESC or click backdrop to close).</li>
  </ul>
  <pre class="bg-gray-900 text-gray-100 p-3 rounded"><code>&lt;button command="show-modal" commandfor="config-modal"&gt;No Title (floating close)&lt;/button&gt;
&lt;button command="show-modal" commandfor="config-modal" data-title="No Close" data-close-button="false"&gt;Hide close button&lt;/button&gt;</code></pre>
  <div class="mt-2 flex flex-wrap gap-2">
    <?php
    echo Button::render('No Title (floating close)', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    echo Button::render('Hide close button', [
        'size' => 'sm',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
            'data-title' => 'No Close Button',
            'data-close-button' => 'false',
            'hx-get' => '../external_modal.php',
            'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
  </div>

  <h3 class="text-lg font-semibold mt-6">Programmatic control (optional)</h3>
  <p>You can also set attributes on the dialog element directly: <code>#config-modal</code> supports <code>data-title</code>, <code>data-close-button</code>, <code>data-size</code>, <code>data-width</code>, <code>data-heigth</code>/<code>data-height</code>, and <code>data-url</code>. Changing these attributes updates the modal automatically.</p>
</div>
<?php
$content = ob_get_clean();

echo layout($content);
