<?php
// pages/components/trigger_module_route.php
// Route handler to render a single trigger module card by key

if (!defined('BEEZUI_ROOT')) {
    define('BEEZUI_ROOT', dirname(__DIR__, 2)); // pages/components => root
}

require_once BEEZUI_ROOT . '/vendor/autoload.php';
require_once BEEZUI_ROOT . '/components/Autoload.php';
require_once BEEZUI_ROOT . '/components/index.php';

use Components\ModuleLoader;
use Components\Base;

if (session_status() === PHP_SESSION_NONE) {
    @session_start();
}

$key = mh_get('module', '', 'key');
if ($key === '') {
    http_response_code(400);
    echo '<div class="text-sm text-red-600">Missing module key</div>';
    return;
}

$all = ModuleLoader::all();
$m = $all[$key] ?? null;
if (!$m) {
    http_response_code(404);
    echo '<div class="text-sm text-red-600">Unknown module: ' . Base::h($key) . '</div>';
    return;
}

// Reuse the generic partial that expects $m in scope
include __DIR__ . '/trigger_module.php';
