<?php
// pages/dashboard.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';

use Components\RadialProgress;
use Components\RadialProgressWidget;

// kept for future use
use Components\Button;
use Components\CampaignFlow\FlowViz;
use Components\CampaignFlow\FlowBuilder;

$pageId = 'dashboard';
ob_start();
?>
    <div class="hidden">
        <h3 class="text-lg font-semibold mb-2">Dashboard</h3>
        <p class="text-gray-600">Welcome to your MailBeez dashboard. KPIs, recent activity, and quick links.</p>
    </div>
    <!--Summary Widget Start -->
<?php include BEEZUI_ROOT . '/pages/components/dashboard_summary.php'; ?>
    <!--Summary Widget End -->

    <div class="mt-4 flex flex-wrap gap-2">
        <?php

        if (file_exists(MH_DIR_REPORT . 'report_analytics_advanced/report_analytics_advanced.php')) {
            include_once(MH_DIR_REPORT . 'report_analytics_advanced.php');
        }

        $analyticsUrl = (class_exists('report_analytics_advanced')) ? \report_analytics_advanced::getLink([], 'this_year') : '';

        if ($analyticsUrl != '') {
            echo Button::render('MailBeez Analytics', [
                    'variant' => 'primary',
                    'size' => 'md',
                    'icon' => \Components\Base::SVG_OUTLINE_CHART_PIE,
                    'attrs' => [
                            'command' => 'show-modal',
                            'commandfor' => 'config-modal',
                            'data-title' => 'MailBeez Analytics',
                            'data-size' => 'full-margin',
                            'data-url' => $analyticsUrl,
                    ],
            ]);
        }
        ?>
    </div>

    <div class="mt-4 flex flex-wrap gap-2 hidden">
        <?php
        echo Button::render('Open Campaigns', [
                'variant' => 'primary',
                'size' => 'md',
                'attrs' => [
                        'command' => 'show-modal',
                        'commandfor' => 'config-modal',
                        'data-size' => 'full-margin',
                        'data-url' => '../external_modal.php',
                        'hx-target' => '#config-modal-body',
                        'hx-swap' => 'innerHTML',
                ],
        ]);

        echo Button::render('Config Modal Docs', [
                'variant' => 'ghost',
                'size' => 'md',
                'attrs' => [
                        'command' => 'show-modal',
                        'commandfor' => 'config-modal',
                        'data-title' => 'Config Modal Docs',
                        'data-size' => 'full',
                        'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                        'hx-target' => '#config-modal-body',
                        'hx-swap' => 'innerHTML',
                ],
        ]);
        ?>
    </div>

<?php
// Demo data for Campaign Flow visualization

$flowItems = FlowBuilder::make()
        ->trigger('Purchase')
        ->subtitle('Trigger')
        ->icon(\Components\Base::SVG_TRIGGER)
        ->color('blue')
        ->marker(' text-blue-500/70 ', 'Filter applied', \Components\Base::SVG_FILTER)
        ->wait('30 days', [
                'attrs' => [
                        'command' => 'show-modal',
                        'commandfor' => 'config-modal',
                        'data-title' => 'Step 1 – Details',
                        'data-size' => 'full',
                        'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                        'hx-target' => '#config-modal-body',
                        'hx-swap' => 'innerHTML',
                ]

        ])
        ->step('step1', 'Reminder Email', [
                'subtitle' => 'Step 1',
                'icon' => \Components\Base::SVG_MAIL,
                'color' => 'indigo',
            // Make the card clickable to open modal docs via htmx
                'attrs' => [
                        'command' => 'show-modal',
                        'commandfor' => 'config-modal',
                        'data-title' => 'Step 1 – Details',
                        'data-size' => 'full',
                        'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                        'hx-target' => '#config-modal-body',
                        'hx-swap' => 'innerHTML',
                ],
            // Example dropdown menu using Tailwind Plus Elements
                'dropdown' => [
                        'trigger' => ['label' => '', 'icon' => '', 'class' => ''],
                        'items' => [
                                ['label' => 'Edit', 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
  <path stroke-linecap="round" stroke-linejoin="round" d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
</svg>', 'attrs' => ['command' => 'show-modal', 'commandfor' => 'config-modal', 'data-size' => 'full', 'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]), 'hx-target' => '#config-modal-body', 'hx-swap' => 'innerHTML']],
                                ['label' => 'Duplicate', 'icon' => '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
  <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 17.25v3.375c0 .621-.504 1.125-1.125 1.125h-9.75a1.125 1.125 0 0 1-1.125-1.125V7.875c0-.621.504-1.125 1.125-1.125H6.75a9.06 9.06 0 0 1 1.5.124m7.5 10.376h3.375c.621 0 1.125-.504 1.125-1.125V11.25c0-4.46-3.243-8.161-7.5-8.876a9.06 9.06 0 0 0-1.5-.124H9.375c-.621 0-1.125.504-1.125 1.125v3.5m7.5 10.375H9.375a1.125 1.125 0 0 1-1.125-1.125v-9.25m12 6.625v-1.875a3.375 3.375 0 0 0-3.375-3.375h-1.5a1.125 1.125 0 0 1-1.125-1.125v-1.5a3.375 3.375 0 0 0-3.375-3.375H9.75" />
</svg>
', 'attrs' => ['hx-post' => '#', 'hx-swap' => 'none']],
                                ['divider' => true],
                                ['label' => 'Archive', 'attrs' => ['hx-post' => '#', 'hx-swap' => 'none']],
                                ['label' => 'Delete', 'attrs' => ['hx-delete' => '#', 'hx-swap' => 'none', 'class' => 'text-red-600']],
                        ],
                ],
        ])
        ->marker('text-blue-500', 'Filter applied', \Components\Base::SVG_FILTER)
        ->marker('text-orange-500/50', 'Coupon', \Components\Base::SVG_VOUCHER)
        ->wait('60 days')
        ->step('step2', 'Follow-up Email')->subtitle('Step 2')->icon(\Components\Base::SVG_MAIL)->color('yellow')
        ->wait('45 days')
        ->step('step3', 'Final Offer Email')->subtitle('Step 3')->icon(\Components\Base::SVG_MAIL)->color('green')
        ->addButton()
        ->toArray();

$flowItems2 = $flowItems;
array_pop($flowItems2);
array_pop($flowItems2);
array_pop($flowItems2);

// Example: flow with a branch after the first step
$flowItemsBranches = FlowBuilder::make()
        ->trigger('Purchase')
        ->subtitle('Trigger')
        ->icon(\Components\Base::SVG_TRIGGER)
        ->color('blue')
        ->wait('30 days')
        ->step('step1', 'Erste Aktivierung 10% Rabatt', [
                'subtitle' => 'Erste Aktivierung',
                'icon' => \Components\Base::SVG_MAIL,
                'color' => 'indigo',
        ])
        ->branch([
                        function (FlowBuilder $b) {
                            $b->wait('35 days')
                                    ->step('step-top-1', 'Dritte Aktivierung 10% Rabatt', [
                                            'subtitle' => 'Dritte Aktivierung',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'green',
                                    ])
                                    ->wait('61 days')
                                    ->step('step-top-2', 'Aktivierungs-Schleife Gratis Versand', [
                                            'subtitle' => 'Aktivierungs-Schleife',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'brand',
                                    ])
                                    ->branch([
                                            function (FlowBuilder $b) {
                                                $b
                                                        ->condition('No Order')
                                                        ->wait('35 days')
                                                        ->step('step-top-1', 'Dritte Aktivierung 10% Rabatt', [
                                                                'subtitle' => 'Dritte Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'green',
                                                        ])
                                                        ->wait('61 days')
                                                        ->step('step-top-2', 'Aktivierungs-Schleife Gratis Versand', [
                                                                'subtitle' => 'Aktivierungs-Schleife',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'brand',
                                                        ])
                                                        ->branch(
                                                                [
                                                                        function (FlowBuilder $b) {
                                                                            $b->wait('35 days')
                                                                                    ->step('step-top-1', 'Dritte Aktivierung 10% Rabatt', [
                                                                                            'subtitle' => 'Dritte Aktivierung',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'green',
                                                                                    ])
                                                                                    ->wait('61 days')
                                                                                    ->step('step-top-2', 'Aktivierungs-Schleife Gratis Versand', [
                                                                                            'subtitle' => 'Aktivierungs-Schleife',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'brand',
                                                                                    ]);
                                                                        },
                                                                        function (FlowBuilder $b) {
                                                                            $b->wait('30 days')
                                                                                    ->step('step-bottom-1', 'Zweite Aktivierung Ohne Gutschein', [
                                                                                            'subtitle' => 'Zweite Aktivierung',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'gray',
                                                                                    ])
                                                                                    ->wait('30 days')
                                                                                    ->step('step-bottom-2', 'Zweite Aktivierung Ohne Gutschein', [
                                                                                            'subtitle' => 'Zweite Aktivierung',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'gray',
                                                                                    ]);
                                                                        },
                                                                        function (FlowBuilder $b) {
                                                                            $b->wait('30 days')
                                                                                    ->step('step-bottom-1', 'Zweite Aktivierung Ohne Gutschein', [
                                                                                            'subtitle' => 'Zweite Aktivierung',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'gray',
                                                                                    ])
                                                                                    ->wait('30 days')
                                                                                    ->step('step-bottom-2', 'Zweite Aktivierung Ohne Gutschein', [
                                                                                            'subtitle' => 'Zweite Aktivierung',
                                                                                            'icon' => \Components\Base::SVG_MAIL,
                                                                                            'color' => 'gray',
                                                                                    ]);
                                                                        }
                                                                ]
                                                                ,
                                                                ['gap' => 'md']
                                                        );
                                            },
                                            function (FlowBuilder $b) {
                                                $b->wait('30 days')
                                                        ->step('step-bottom-1', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ])
                                                        ->wait('30 days')
                                                        ->step('step-bottom-2', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ]);
                                            },
                                            function (FlowBuilder $b) {
                                                $b->wait('30 days')
                                                        ->step('step-bottom-1', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ])
                                                        ->wait('30 days')
                                                        ->step('step-bottom-2', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ]);
                                            },
                                            function (FlowBuilder $b) {
                                                $b->wait('30 days')
                                                        ->step('step-bottom-1', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ])
                                                        ->wait('30 days')
                                                        ->step('step-bottom-2', 'Zweite Aktivierung Ohne Gutschein', [
                                                                'subtitle' => 'Zweite Aktivierung',
                                                                'icon' => \Components\Base::SVG_MAIL,
                                                                'color' => 'gray',
                                                        ]);
                                            }
                                    ],
                                            ['gap' => 'md']
                                    );
                        },

                        function (FlowBuilder $b) {
                            $b->wait('35 days')
                                    ->step('step-top-1', '!Dritte Aktivierung 10% Rabatt', [
                                            'subtitle' => 'Dritte Aktivierung',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'green',
                                    ])
                                    ->wait('61 days')
                                    ->step('step-top-2', 'Aktivierungs-Schleife Gratis Versand', [
                                            'subtitle' => 'Aktivierungs-Schleife',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'brand',
                                    ])//                            ->addButton()

                            ;
                        },

                        function (FlowBuilder $b) {
                            $b->wait('35 days')
                                    ->step('step-top-1', '!Dritte Aktivierung 10% Rabatt', [
                                            'subtitle' => 'Dritte Aktivierung',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'green',
                                    ])
                                    ->addButton();
                        },

                        function (FlowBuilder $b) {
                            $b->wait('35 days')
                                    ->step('step-top-1', '!Dritte Aktivierung 10% Rabatt', [
                                            'subtitle' => 'Dritte Aktivierung',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'green',
                                    ])
                                    ->wait('61 days')
                                    ->step('step-top-2', 'Aktivierungs-Schleife Gratis Versand', [
                                            'subtitle' => 'Aktivierungs-Schleife',
                                            'icon' => \Components\Base::SVG_MAIL,
                                            'color' => 'brand',
                                    ]);
                        }
                ]
        )
        ->addTail(true)
        ->toArray();
?>

    <div class="mt-10 hidden">
        <div class="inline-block w-full">
            <h3 class="text-lg font-semibold mb-3">Campaign Flow — with Branches</h3>
            <?= FlowViz::render($flowItemsBranches, ['orientation' => 'horizontal', 'size' => 'sm', 'editable' => false, 'class' => 'max-w-6xl']); ?>
        </div>
    </div>

    <div class="mt-10 space-y-10 hidden">
        <div>
            <div class="inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Horizontal – md)</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'horizontal', 'size' => 'md', 'editable' => false, 'class' => 'max-w-5xl mx-auto']); ?>
            </div>
        </div>
        <div>

            <div class=" inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Horizontal – md)</h3>
                <?= FlowViz::render(($flowItems2), ['orientation' => 'horizontal', 'size' => 'md', 'editable' => false, 'class' => 'max-w-5xl']); ?>
            </div>
        </div>

        <div>
            <div class="inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Horizontal – sm)</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'horizontal', 'size' => 'sm', 'editable' => false, 'class' => 'max-w-5xl mx-auto']); ?>
            </div>
        </div>
        <div>

            <div class=" inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Horizontal – sm)</h3>
                <?= FlowViz::render(($flowItems2), ['orientation' => 'horizontal', 'size' => 'sm', 'editable' => false, 'class' => 'max-w-5xl']); ?>
            </div>
        </div>

        <div>
            <div class="inline-block">
                <h3 class="text-sm font-medium mb-2">Compact (xs) – fits dropdown</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'horizontal', 'size' => 'xs', 'editable' => false, 'class' => '']); ?>
            </div>
        </div>

        <div>
            <div class="inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Vertical – sm)</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'vertical', 'size' => 'sm', 'editable' => false, 'class' => 'max-w-md mx-auto']); ?>
            </div>
        </div>


        <div>
            <div class="inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Vertical – md)</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'vertical', 'size' => 'md', 'editable' => false, 'class' => 'max-w-md mx-auto']); ?>
            </div>
        </div>
        <div>
            <div class="inline-block">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Vertical – lg)</h3>
                <?= FlowViz::render($flowItems, ['orientation' => 'vertical', 'size' => 'lg', 'editable' => false, 'class' => 'max-w-md mx-auto']); ?>
            </div>
        </div>

        <div>
            <div class="inline-block hidden">
                <h3 class="text-lg font-semibold mb-3">Campaign Flow (Editable – lg)</h3>
                <p class="text-xs text-gray-500 mb-2">Click a timer badge to edit the wait label.</p>
                <?= FlowViz::render($flowItems, ['orientation' => 'horizontal', 'size' => 'lg', 'editable' => true, 'class' => 'max-w-5xl mx-auto']); ?>
            </div>
        </div>


    </div>

<?php
$content = ob_get_clean();

echo layout($pageId, $content);
