<?php
// pages/newsletter.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';


use Components\Card;
use Components\Resources\CollectionsList;
use Components\Resources\ItemList as FlowItemList;
use Components\Models\NewsletterCampaign;
use Components\Models\NewsletterItem;
use Components\Router as R;
$pageKey = 'newsletter';
$targetContainer = \Components\Data\DataRegistry::navigation()->getTargetId($pageKey);

ob_start();
?>
    <div>
        <h3 class="text-lg font-semibold mb-2">Newsletter</h3>
    </div>

<?php

/*
 *     <!-- Campaigns CRUD demo -->
    <div class="mt-6">
        <h2 class="text-lg font-semibold mb-2">Campaigns</h2>
        <div id="newsletter-campaigns-list"
             hx-get="<?= \Components\Router::url('newsletter_campaigns_list', ['partial' => 1]) ?>"
             hx-trigger="load"
             hx-swap="outerHTML">
            <div class="text-sm text-muted">Loading campaigns…</div>
        </div>
    </div>

    <!-- Items CRUD demo -->
    <div class="mt-6">
        <h2 class="text-lg font-semibold mb-2">Items</h2>
        <div id="newsletter-items-list"
             hx-get="<?= \Components\Router::url('newsletter_items_list', ['partial' => 1]) ?>"
             hx-trigger="load"
             hx-swap="outerHTML">
            <div class="text-sm text-muted">Loading items…</div>
        </div>
    </div>

 */

?>

<div class="my-6">
  <?php
  // Refactor: Load Collections and Flows via hx-get components, preserving selected group
  $pageKey = 'newsletter';
  $selectedGroup = mh_get('group', '', 'string'); // slug like 'campaign-<id>' or '' (all)
  $groupParam = $selectedGroup !== '' ? ['group' => $selectedGroup] : [];
  ?>

  <div class="flex gap-6">
      <!-- Collections (NewsletterCampaign) via component -->
      <div id="newsletter-campaigns-list"
           hx-get="<?= \Components\Router::url('newsletter_campaigns_list', array_merge(['partial' => 1], $groupParam)); ?>"
           hx-trigger="load"
           hx-swap="outerHTML">
          <div class="text-sm text-muted">Loading collections…</div>
      </div>

      <!-- Flows (NewsletterItem) via component -->
      <div class="flex-1 min-w-0">
          <div id="newsletter-items-list"
               hx-get="<?= \Components\Router::url('newsletter_items_list', array_merge(['partial' => 1], $groupParam)); ?>"
               hx-trigger="load"
               hx-swap="outerHTML">
              <div class="text-sm text-muted">Loading flows…</div>
          </div>
      </div>
  </div>
</div>


    <div class="space-y-4 hidden">

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <?php
            // Refactored to use Components\Card
            $body1 = '<p class="mt-1 text-sm text-gray-600">One-time send to all – e.g. Black Friday, new product.<br><span class="text-gray-500">Einmaliger Versand an alle – z. B. Black Friday, neues Produkt.</span></p>';
            $icon1 = '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><path d="M3 11V7a4 4 0 0 1 4-4h1l5-2v16l-5-2H7a4 4 0 0 1-4-4z"/><path d="M14 7h7"/><path d="M14 11h5"/></svg>';
            echo Card::render('Announcement / Einmalige Ankündigung', $body1, $icon1);

            $body2 = '<p class="mt-1 text-sm text-gray-600">Send to all matching customers within a defined period.<br><span class="text-gray-500">Versand an alle passenden Kunden innerhalb eines definierten Zeitraums.</span></p>';
            $icon2 = '<svg xmlns="http://www.w3.org/2000/svg" class="size-6 text-emerald-600" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2"><circle cx="12" cy="12" r="10"/><polyline points="12 6 12 12 16 14"/></svg>';
            echo Card::render('Timed Campaign / Zeitraum-Kampagne', $body2, $icon2);


            ?>
        </div>
    </div>


<?php
$content = ob_get_clean();

echo layout($pageKey, $content);
