<?php
// pages/template_coupons.php
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';

use Components\Button;
use Components\Card;
use Components\Base;

$pageKey = 'template_coupons';
$targetContainer = '#app-container-' . $pageKey;

// Load templates via data provider when available; fallback to static list
$templates = $templates ?? null;
try {
    $prov = \Components\Data\DataRegistry::templateCoupons();
    if ($prov) {
        $data = $prov->templates(false);
        if (is_array($data) && $data) {
            $templates = $data;
        }
    }
} catch (\Throwable $e) {
    // ignore and fallback to static
}


ob_start();
?>
    <div>
        <div class="hidden flex items-end justify-between gap-4 mb-4">
            <div>
                <h3 class="text-lg font-semibold mb-1">Template Coupons</h3>
                <p class="text-gray-600 dark:text-gray-300">Pick a ready‑made coupon template to jump‑start your next
                    campaign. You can customize content and styling afterwards.</p>
            </div>
            <div class="flex gap-2">
                <?php echo Button::render('Back to Newsletter', [
                        'variant' => 'secondary',
                        'attrs' => [
                                'hx-get' => \Components\Router::url('newsletter', ['partial' => 1]),
                                'hx-target' => $targetContainer,
                                'hx-swap' => 'innerHTML',
                                'hx-push-url' => \Components\Router::url('newsletter')
                        ]
                ]); ?>
            </div>
        </div>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
            <?php foreach ($templates as $tpl): ?>
                <?php
               $label =$tpl['typeLabel'];
                $code = Base::h($tpl['code']);
                $name = Base::h($tpl['name']);
                $bodyHtml = <<<HTML
                <div class="flex w-full flex-row items-center justify-between text-xs text-gray-600">
                <div class="">{$name}</div>
                <div class="rounded-lg border border-divider px-1.5 py-0.5">{$label}</div>
                </div>
                HTML;
                $actions = '<div class="flex items-center gap-2">'
                        . Button::render('Use Template', [
                                'attrs' => [
                                    // Placeholder action – can be wired to editor/config later
                                        'hx-get' => \Components\Router::url('newsletter', ['partial' => 1]),
                                        'hx-target' => $targetContainer,
                                        'hx-swap' => 'innerHTML',
                                        'hx-push-url' => \Components\Router::url('newsletter')
                                ]
                        ])
                        . Button::render('Preview', [
                                'variant' => 'secondary',
                                'attrs' => [
                                        'command' => 'show-modal',
                                        'commandfor' => 'config-modal',
                                        'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                                        'hx-target' => '#config-modal-body',
                                        'hx-swap' => 'innerHTML'
                                ]
                        ])
                        . '</div>';
                $icon = \Components\Base::SVG_SOLID_VOUCHER;
                $actions = null;
                echo Card::render($code, $bodyHtml, $icon, $actions);
                ?>
            <?php endforeach; ?>
        </div>

        <div class="mt-6">
            <h2 class="text-lg font-semibold mb-2">Coupons</h2>
            <div id="coupons-list"
                 hx-get="<?= \Components\Router::url('coupons_list', ['partial' => 1]) ?>"
                 hx-trigger="load"
                 hx-swap="outerHTML">
                <div class="text-sm text-muted">Loading coupons…</div>
            </div>
        </div>
    </div>
<?php
$content = ob_get_clean();

echo layout($pageKey, $content);
