<?php
// pages/trigger_sort.php (refactored from campaigns_sort.php)
require_once BEEZUI_ROOT . '/components/index.php';
require_once __DIR__ . '/layout.php';

use Components\SortStore;
use Components\Router;
use Components\Base;
use Components\ModuleLoader;

$pageKey = 'trigger';
$targetContainer = '#app-container-' . $pageKey;

$layout = mh_get('layout', 'tiles', 'string');

// Detect if rendering inside drawer/htmx partial
$isPartial = (\Components\Support\Htmx::isRequest()) || (mh_get('partial', 0, 'int') == 1);

// Preserve current URL parameters to return to campaigns and for POST target
$keepParams = \Components\Common\Request::all('get');
$pageParam = Router::pageParam();
$tabParam = Router::tabParam();
unset($keepParams['partial'], $keepParams[$pageParam], $keepParams[$tabParam]);
// Render the sort UI
$items = SortStore::campaignListOrdered();
ob_start();
?>
<div class="p-4" x-data>
    <div class="flex items-center justify-between mb-4">
        <div class="flex items-center gap-2">
            <?php if ($isPartial): ?>
            <button type="button" class="inline-flex items-center gap-2 rounded-md border border-gray-200 bg-white px-3 py-2 text-sm text-gray-700 shadow-sm hover:bg-gray-50"
                    command="close" commandfor="config-drawer">
                <svg class="w-4 h-4 text-gray-500" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path d="M12.707 14.707a1 1 0 01-1.414 0L6.586 10l4.707-4.707a1 1 0 111.414 1.414L9.414 10l3.293 3.293a1 1 0 010 1.414z"/></svg>
                Back
            </button>
            <?php else: ?>
            <button class="inline-flex items-center gap-2 rounded-md border border-gray-200 bg-white px-3 py-2 text-sm text-gray-700 shadow-sm hover:bg-gray-50"
                    hx-get="<?= Router::url('trigger', array_merge(['partial' => 1], $keepParams)); ?>"
                    hx-target="<?= $targetContainer; ?>"
                    hx-swap="innerHTML"
                    hx-push-url="<?= Router::url('trigger', $keepParams); ?>">
                <svg class="w-4 h-4 text-gray-500" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path d="M12.707 14.707a1 1 0 01-1.414 0L6.586 10l4.707-4.707a1 1 0 111.414 1.414L9.414 10l3.293 3.293a1 1 0 010 1.414z"/></svg>
                Back
            </button>
            <?php endif; ?>
            <h3 class="text-base font-semibold text-gray-900 dark:text-white">Sort Campaigns</h3>
        </div>
        <div class="text-sm text-gray-500 dark:text-gray-300">Drag to reorder. 0 = top.</div>
    </div>

    <div id="sort-alert" class="mb-4"></div>

    <div id="sort-list"
         class="space-y-2"
         x-sort
    >
        <?php foreach ($items as $m): ?>
            <div class="flex items-center justify-between gap-3 bg-white dark:bg-gray-800 border border-gray-200 dark:border-white/10 rounded-md px-3 py-2"
                 x-sort:item
                 data-key="<?php echo Base::h($m['key']); ?>">
                <div class="flex items-center gap-3">
                    <svg class="w-5 h-5 text-gray-400 cursor-grab" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path d="M7 4h2v2H7V4zm0 5h2v2H7V9zm0 5h2v2H7v-2zm4-10h2v2h-2V4zm0 5h2v2h-2V9zm0 5h2v2h-2v-2z"/></svg>
                    <div>
                        <div class="text-sm font-medium text-gray-900 dark:text-white"><?php echo Base::h($m['title']); ?></div>
                        <div class="text-xs text-gray-500 dark:text-gray-300"><?php echo Base::h($m['group']); ?> · <?php echo Base::h($m['key']); ?></div>
                    </div>
                </div>
                <div class="text-xs text-gray-400 select-none">drag</div>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="mt-6 flex justify-end gap-2">
        <?php if ($isPartial): ?>
        <button type="button" class="px-3 py-2 text-sm rounded-md border border-gray-300 dark:border-white/20 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700"
                command="close" commandfor="config-drawer">Cancel</button>
        <?php else: ?>
        <button type="button" class="px-3 py-2 text-sm rounded-md border border-gray-300 dark:border-white/20 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700"
                hx-get="<?= Router::url('trigger', array_merge(['partial' => 1], $keepParams)); ?>"
                hx-target="<?= $targetContainer; ?>"
                hx-swap="innerHTML"
                hx-push-url="<?= Router::url('trigger', $keepParams); ?>">Cancel</button>
        <?php endif; ?>
        <button type="button"
                class="px-3 py-2 text-sm rounded-md bg-brand text-white hover:bg-brand-700"
                hx-post="<?= Router::url('trigger', array_merge(['partial' => 1], $keepParams)); ?>"
                hx-target="#sort-alert"
                hx-swap="innerHTML"
                hx-vals="js:{ order: (function(){
                    var keys = Array.from(document.querySelectorAll('#sort-list > [data-key]')).map(el => el.getAttribute('data-key'));
                    return JSON.stringify(keys);
                })() }"
        >
            Save order
        </button>
    </div>
</div>
<?php
$content = ob_get_clean();

echo $isPartial ? $content : layout($pageKey,$content);
