<?php
// pages/wizard.php
if (!defined('BEEZUI_ROOT')) {
    // This file resides in <root>/pages
    define('BEEZUI_ROOT', dirname(__DIR__));
}
require_once BEEZUI_ROOT . '/components/index.php';
require_once BEEZUI_ROOT . '/pages/layout.php';

use Components\Base;
use Components\Button;
$pageKey = 'wizard';
$targetContainer = '#app-container-' . $pageKey;

ob_start();
?>
<div class="max-w-4xl">
  <div class="mb-6">
    <h1 class="text-2xl font-semibold">Setup Wizard</h1>
    <p class="mt-2 text-gray-600 dark:text-gray-300">Let's get you to your goal quickly. Choose what you want to do and we'll guide you step by step — no technical knowledge required.</p>
    <div class="mt-4">

            <?php
    echo Button::render('AI Modal flow', [
        'variant' => 'primary',
        'size' => 'md',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'ai-modal',
//            'data-title' => 'Campaigns',
            'data-size' => 'xl',
//'data-height' => '50vh',
            'hx-get' => route('assistant'),
            'hx-target' => '#ai-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
            <?php
    echo Button::render('AI Modal config', [
        'variant' => 'primary',
        'size' => 'md',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'ai-modal',
//            'data-title' => 'Campaigns',
            'data-size' => 'xl',
//'data-height' => '50vh',
            'hx-get' => route('assistant', ['flow' => 'blueprint']),
            'hx-target' => '#ai-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
            <?php
    echo Button::render('config-modal', [
        'variant' => 'primary',
        'size' => 'md',
        'attrs' => [
            'command' => 'show-modal',
            'commandfor' => 'config-modal',
//            'data-title' => 'Campaigns',
            'data-size' => 'xl',
//'data-height' => '50vh',
                'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                'hx-target' => '#config-modal-body',
            'hx-swap' => 'innerHTML',
        ],
    ]);
    ?>
            <?php


            echo Button::render('Config Modal Docs', [
                    'variant' => 'ghost',
                    'size' => 'md',
                    'attrs' => [
                            'command' => 'show-modal',
                            'commandfor' => 'config2-modal',
                            'data-title' => 'Config Modal Docs',
                            'data-size' => 'md',
                            'hx-get' => \Components\Router::url('config_modal_docs', ['partial' => 1]),
                            'hx-target' => '#config2-modal-body',
                            'hx-swap' => 'innerHTML',
                    ],
            ]);

    ?>

    </div>
  </div>

  <div id="wizard-body">
    <?php include __DIR__ . '/wizard/step_goal.php'; ?>
  </div>
</div>
<?php
$content = ob_get_clean();

echo layout($pageKey,$content);
