<?php

class mailbeez_frontmatter
{
    static $frontmatter_path = 'undefined';

    static function _init_dialog($frontmatter_path, $view)
    {
        $smarty = new mh_Smarty;
        $smarty->setTemplateDir(MH_DIR_FS_CATALOG . MH_ROOT_PATH . $frontmatter_path . "views/$view/templates/");
        $smarty->setConfigDir(MH_DIR_FS_CATALOG . MH_ROOT_PATH . $frontmatter_path . "views/$view/languages/");
        $smarty->setCompileCheck(true);
        $smarty->setCompileId(md5($frontmatter_path) . $view);
        $smarty->setCaching(false);

        $language = 'english';
        $languages_id = $_SESSION['languages_id'];


        $mh_url = mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH');
        $resource_root = $mh_url . 'common/';

        $smarty->assign('mailhive_path', $mh_url);
        $smarty->assign('privacy_policy_url', mh_cfg('MAILBEEZ_CONFIG_SITEBEEZ_PRIVACY_POLICY_URL', 'https://' . $_SERVER['SERVER_NAME']));

        if (stristr(MAILBEEZ_MAILHIVE_URL_DIRECT, '.php')) {
            // mailhive.php/api/public/v1.0/newsletter/add/
            $smarty->assign('entrypoint_url', MAILBEEZ_MAILHIVE_URL_DIRECT . '/');
        } else {
            // /m/api/public/v1.0/newsletter/add/
            $smarty->assign('entrypoint_url', MAILBEEZ_MAILHIVE_URL_DIRECT);
        }



        $smarty->assign(array(
                'js' => array(
                    'micromodal' => $resource_root . 'vendor/ghosh/micromodal/micromodal.min.js?ver=' . mh_cfg('MAILBEEZ_VERSION'),
                ),
                'css' => array(
                    'bootstrap' => $resource_root . 'vendor/bootstrap/css/bootstrap.min.css?ver=' . mh_cfg('MAILBEEZ_VERSION'),
                    'bootstrap_v3' => $resource_root . 'vendor/bootstrap/css/bootstrap.min.css?ver=' . mh_cfg('MAILBEEZ_VERSION'),
                    'bootstrap_v4' => $resource_root . 'vendor/bootstrap-4.1.1/css/bootstrap.min.css?ver=' . mh_cfg('MAILBEEZ_VERSION'),
                    'fontawesome' => $resource_root . 'css/font-awesome/css/font-awesome.min.css?ver=' . mh_cfg('MAILBEEZ_VERSION')
                )
            )
        );
        if (file_exists($smarty->getConfigDir(0) . $_SESSION['language'] . '.conf')) {
            $language = $_SESSION['language'];
            $smarty->configLoad($language . '.conf');
        }

        if (mh_get('language')) {
            $setLng = mh_get('language');
            $smarty->assign('setLanguage', mh_get('language')); // url parameter
            $smarty->assign('lngUrl', "&language={$setLng}"); // url to set language
        }

        $smarty->assign('language', $language); // available .conf file language
        $smarty->assign('language_session', $_SESSION['language']); // original
        $smarty->assign('languages_id', $languages_id); // original
        return $smarty;
    }
}