<?php

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_cache.php');

class mailbeez_storage extends mailbeez_cache
{

    private $storage;
    private $group;

    function __construct($group)
    {
        parent::__construct();
        $this->code = 'mailbeez_storage';
        $this->group = $group;
        $this->storage = [];
    }

    function set($key, $value)
    {
        $this->set_cache_id($key, 'mhstrg_' . $this->group);

        $this->storage[$key] = $value;

        return $this->set_cache($value, 'app');
    }

    function get($key)
    {
        if (isset($this->storage[$key])) {
            return $this->storage[$key];
        }

        $this->set_cache_id($key, 'mhstrg_' . $this->group);
        $data = $this->read_cache('app');

        if (is_array($data)) {
            $this->storage[$key] = $data['value'];
            return $data['value'];
        }
        return false;

    }

    function destroy($key)
    {
        if (!isset($this->storage[$key])) {
            return true;
        }

        $this->set_cache_id($key, 'mhstrg_' . $this->group);
        $this->purge_cache('app');
        unset($this->storage[$key]);

    }

}