<?php

class query_watchdog
{
    function __construct()
    {
        $this->slow_query_time_limit = mh_cfg('MAILBEEZ_WATCHDOG_LIMIT_KILL');
        $this->slow_query_time_limit_kill = mh_cfg('MAILBEEZ_WATCHDOG_LIMIT_KILL');
        $this->logFile = MH_DIR_FS_LOGS . 'query_watchdog.log';
    }

    function query_watchdog()
    {
        self::__construct();
    }

    function watch()
    {
        if (mh_cfg('MAILBEEZ_WATCHDOG_STATUS') != 'True') {
            return false;
        }

        $killed = false;
        $process_query = mh_db_query("show full processlist;");
        while ($process_item = mh_db_fetch_array($process_query)) {
            $slow_query_time = $process_item['Time'];
            $slow_query_pid = $process_item['Id'];
            $slow_query_slq = $process_item['Info'];

            if ($process_item['Command'] != 'Sleep' && $slow_query_time > $this->slow_query_time_limit) {
                if ($slow_query_time > $this->slow_query_time_limit_kill) {
                    $this->kill($slow_query_pid);
                    $this->log("killed slow process after $slow_query_time s:  $slow_query_slq");

                    $killed = true;
                }
            }
        }

        if ($killed) {
            $killed = sprintf(MAILBEEZ_WATCHDOG_WARNING, $this->slow_query_time_limit_kill, $this->logFile);

            require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/notificationbeez.php');
            $this->notficationsObj = new notificationbeez();
            // once a day
            $uid = date("Yz");

            $notification = array('title' => mh_cfg('MAILBEEZ_VIEW_QUERY_WATCHDOG_NOTIFICATION_TITLE'),
                'notification_summary' => mh_cfg('MAILBEEZ_VIEW_QUERY_WATCHDOG_NOTIFICATION_SUMMARY'),
                'notification' => $killed,
                'module' => 'MailBeez Watchdog',
                'ref_id' => $uid,
                'iteration' => 1,
                'customers_id' => null,
                'severity' => 1,
                'link' => mh_cfg('MAILBEEZ_CONTEXT_VIEW_URL') . '&view_module=view_dashboard&dashboard_module=view_notifications&dashboard_viewpage=open&popup=true',
                'link_type' => 'P', // E - external, I - internal, P - popup
                'notification_only' => 'true',
                'panel_click_action' => '', // H - hide
                'channel_id' => 0,
                'status' => '0',
                'icon_style' => 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_customer_insight/viewbeez/view_query_watchdog/icon_panel.png); background-color: #da4f49');

            $this->notficationsObj->add($notification);


        }
        return $killed;
    }


    function kill($pid)
    {
        $process_query = mh_db_query("kill $pid;");
    }

    function log($msg)
    {
        $filename = $this->logFile;
        $stream = fopen($filename, 'a');
        $string = "[" . date("Y/m/d h:i:s", time()) . "] " . $msg;
        fwrite($stream, $string . PHP_EOL);
        fclose($stream);
    }

}

?>