<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License

  v2.9.4

  template functions
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////
// path to smarty library


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/class.html2text.php');
mh_define('MH_TEMPLATE_ENGINE_LOGFILE', MH_DIR_FS_LOGS . 'template_engine_failed.log');


if (!class_exists('Smarty')) {
    if (mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_SMARTY_PATH')) {
        require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/' . mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_SMARTY_PATH') . '/Smarty.class.php'); // include smarty
    } else {
        //trigger_error("configuration error - Smarty not found", E_USER_ERROR);
    }
}

mh_define('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_CACHING', false);
mh_define('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_TEMPLATE_DIR', MH_DIR_FS_CATALOG . 'mailhive');
mh_define('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR', MH_DIR_FS_WORK);
mh_define('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_CACHE_DIR', MH_DIR_FS_CACHE);
mh_define('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_CONFIG_DIR', '');


function mh_template_check_writeable()
{
    $test_folder = mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR');
    $test_file = 'template_c_write_test.txt';
    if (!file_exists($test_folder . $test_file)) {
        @chmod($test_folder, 0777);
        @touch($test_folder . $test_file);
        @chmod($test_folder, 0755);
        if (!file_exists($test_folder . $test_file)) {
            return false;
        }
    }

    return is_writable($test_folder . $test_file);
}

function mh_template_convert($text, $replace_variables)
{
    // deprec
    return $text;
    // make old template compatible with smarty
    /*
    if (is_array($replace_variables)) {
        uksort($replace_variables, "sortbykeylength");
        foreach ($replace_variables as $key => $value) {
            $text = str_replace('$' . $key, $value, $text);
        }
    }
    return $text;
    */
}

function mh_template_bypass_smarty($text, $replace_variables)
{
    // make old template compatible with smarty
    if (is_array($replace_variables)) {
        uksort($replace_variables, "sortbykeylength");
        foreach ($replace_variables as $key => $value) {
            $text = str_replace('{$' . $key . '}', $value, $text);
        }
    }
    return $text;
}

function mh_template_parse_css_tags($text, $replace_variables, $del = array('left' => '[##', 'right' => '##]'))
{
    // replace e.g. [##$catalog_server##] in css
    if (is_array($replace_variables)) {
        uksort($replace_variables, "sortbykeylength");
        foreach ($replace_variables as $key => $value) {

            if (is_array($value)) {
                continue;
            }

            $replace = $del['left'] . '$' . $key . $del['right'];


            $text = str_replace(
                $replace,
                $value,
                $text
            );


        }
    }


    // remove empty css tags
    $text = str_replace((string)$del['left'] . (string)$del['right'], '', $text);

    return $text;
}

function mh_smarty_compile_dir_info()
{
    if ($dir = @opendir(MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR)) {
        $c_counter = 0;
        while (false !== ($c_file = readdir($dir))) {
            $c_counter++;
        }
        closedir($dir);
    }
    $c_counter -= 2; // in order to exclude '.' and '..'
    $c_counter = ($c_counter < 0) ? 0 : $c_counter;
    return $c_counter;
}

function mh_smarty_template_exists($smarty, $template)
{
    $smarty_version = mh_smarty_get_version($smarty);

    $templ_exists = false;


    // keep for backwards compatiblity
    if (method_exists($smarty, 'templateExists')) {
        $templ_exists = $smarty->templateExists($template);
    } else {
        die("smarty compatibility issue in mh_smarty_template_exists()");
    }

    /*
    if ($smarty_version == 2) {
        $templ_exists = $smarty->template_exists($template);
    } elseif ($smarty_version == 3) {
        $templ_exists = $smarty->templateExists($template);
    }

    */


    return $templ_exists;
}


function mh_smarty_clear_compile_dir()
{
    if ($dir = @opendir(mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR'))) {
        while (false !== ($c_file = readdir($dir))) {
            if (preg_match('/.php/', $c_file)) {
                //if (preg_match('/.tpl.php/', $c_file)) {
                if (is_file(mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR') . $c_file) && file_exists(mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR') . $c_file)) {
                    unlink(mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMPILE_DIR') . $c_file);
                }
            }
        }
        closedir($dir);
    }
}

/*
function _dprec_mh_smarty_get_template($template_resource, &$tpl_source, &$smarty_obj)
{
    // populating $tpl_source
    $tmpl_res = 'mh_' . $template_resource;
    $tpl_source = $smarty_obj->$tmpl_res;

    return true;
}

function _dprec_mh_smarty_get_timestamp($template_resource, &$tpl_timestamp, &$smarty_obj)
{
    $tmpl_res = 'mh_' . $template_resource . '_mtime';
    $tpl_timestamp = $smarty_obj->$tmpl_res;
    return true;
}

function _dprec_mh_smarty_get_secure($tpl_name, &$smarty_obj)
{
    // assume all templates are secure
    return true;
}

function _dprec_mh_smarty_get_trusted($tpl_name, &$smarty_obj)
{
    // not used for templates
}


function _dprec_mh_smarty_register_resource(&$smarty_obj)
{
    $smarty_version = mh_smarty_get_version($smarty_obj);

    // smarty 2
    if ($smarty_version == 2) {
        $smarty_obj->register_resource("mh", array("mh_smarty_get_template",
            "mh_smarty_get_timestamp",
            "mh_smarty_get_secure",
            "mh_smarty_get_trusted"));
    } elseif ($smarty_version == 3) {
        if (class_exists('Smarty_Resource_Custom')) {
        } else {
            // smarty 3.0.5
            $smarty_obj->registerResource("mh", array("mh_smarty_get_template",
                "mh_smarty_get_timestamp",
                "mh_smarty_get_secure",
                "mh_smarty_get_trusted"));
        }
    }
}
*/


function mh_smarty_get_version($smarty_obj)
{

    if (class_exists('Smarty') && defined('Smarty::SMARTY_VERSION')) {
        // smarty 3.1.x
        $version_string = Smarty::SMARTY_VERSION;
    } else {
        // smarty 2.x, 3.0
        $version_string = $smarty_obj->_version;
    }
    return (int)str_replace('Smarty-', '', $version_string);
}

function mh_smarty_process($smarty, $template_code)
{
    $smarty_obj = $smarty;
    $smarty_version = mh_smarty_get_version($smarty_obj);

    if ($smarty_version == 3 && class_exists('Smarty_Resource_Custom')) {
        // smarty 3.1

        // Gambio /inc/get_usermod.inc.php not compatible with string resource type
        // workaround
        if (MH_PLATFORM_GAMBIO >= 2.3) {
            $smarty_obj->setCompileId('process_v');
            $smarty_obj->setCaching(false);
            $smarty_obj->assign('template_source', mh_smarty_auto_literal($template_code));
            $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');
        } else {
            $output = $smarty_obj->fetch('string:' . mh_smarty_auto_literal($template_code));
        }

    } else {
        // smarty 2 + 3.0
        if (method_exists($smarty_obj, 'setCompileId')) {
            // smarty 3
            $smarty_obj->setCompileId('process_v');
            $smarty_obj->setCaching(false);
        } else {
            $smarty_obj->compile_id = 'process_v';
            $smarty_obj->caching = false;
        }
        $smarty_obj->assign('template_source', mh_smarty_auto_literal($template_code));
        $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');
    }

    return $output;
}

function mh_smarty_fetch($smarty, $resource, $smarty_tmpl_holder = null)
{
    $smarty_obj = $smarty;
    $resource_name = 'mh_' . $resource;

    if ($smarty_tmpl_holder != null && !trim($smarty_tmpl_holder->$resource_name)) {
        return '';
    }

    /*
    $debug = ob_get_contents();
    ob_end_clean();
    echo "### $debug ###";
    */
    // backwards compatiblity for calls w/o $smarty_tmpl_holder
    if ($smarty_tmpl_holder == null) {

        if (method_exists($smarty_obj, 'setCompileId')) {
            // smarty 3
            $smarty_obj->setCompileId($resource_name . '_v');
            $smarty_obj->setCaching(false);
        } else {
            $smarty_obj->compile_id = $resource_name . '_v';
            $smarty_obj->caching = false;
        }
        $smarty_obj->assign('template_source', mh_smarty_auto_literal($smarty->$resource_name));
        $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');
        mh_check_template_data($output, 'mh_smarty_fetch 1');

        return $output;
    }

    $smarty_version = mh_smarty_get_version($smarty_obj);
    if ($smarty_version == 4 && class_exists('Smarty_Resource_Custom')) {
        // smarty 4
        // Gambio /inc/get_usermod.inc.php not compatible with string resource type
        // workaround
        if ((float)MH_PLATFORM_GAMBIO >= 2.3) {
            $smarty_obj->setCompileId($resource_name . '_v');
            $smarty_obj->setCaching(false);
            $smarty_obj->assign('template_source', mh_smarty_fix(mh_smarty_auto_literal($smarty_tmpl_holder->$resource_name)));

            $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');

        } else {
            $output = $smarty_obj->fetch('string:' . $smarty_tmpl_holder->$resource_name);
        }
        mh_check_template_data($output, 'mh_smarty_fetch 2: ' . $resource_name . '|' . $smarty_tmpl_holder->$resource_name . '|' . print_r($smarty_obj, true));
        return $output;

    } else if ($smarty_version == 3 && class_exists('Smarty_Resource_Custom')) {
        // smarty 3.1
        // Gambio /inc/get_usermod.inc.php not compatible with string resource type
        // workaround
        if ((float)MH_PLATFORM_GAMBIO >= 2.3) {
            $smarty_obj->setCompileId($resource_name . '_v');
            $smarty_obj->setCaching(false);
            $smarty_obj->assign('template_source', mh_smarty_auto_literal($smarty_tmpl_holder->$resource_name));
            $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');

        } else {
            $output = $smarty_obj->fetch('string:' . $smarty_tmpl_holder->$resource_name);
        }
        mh_check_template_data($output, 'mh_smarty_fetch 2: ' . $resource_name . '|' . $smarty_tmpl_holder->$resource_name . '|' . print_r($smarty_obj, true));
        return $output;

    } else {
        // smarty 2 + 3.0
        foreach ($smarty_tmpl_holder as $key => $value) {
            $smarty_obj->$key = $value;
        }
        if (method_exists($smarty_obj, 'setCompileId')) {
            // smarty 3
            $smarty_obj->setCompileId($resource_name . '_v');
            $smarty_obj->setCaching(false);
        } else {
            $smarty_obj->compile_id = $resource_name . '_v';
            $smarty_obj->caching = false;
        }

        $smarty_obj->assign('template_source', mh_smarty_auto_literal($smarty_tmpl_holder->$resource_name));
        $output = $smarty_obj->fetch(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/admin_application_plugins/templates/smarty_eval.tpl');

        mh_check_template_data($output, 'mh_smarty_fetch 3: ' . $resource_name . '|' . $smarty_tmpl_holder->$resource_name);
        return $output;
    }
}

function mh_smarty_generate_mail($obj, $mail, $mailbeez_module_path, $smarty, $strip_editor_codes = true, $preparse_template_codes = true)
{

    $smarty_generate = $smarty; // make a copy

    $replace_variables_common = $GLOBALS['mh_template_replace_variables_common'];
    $smarty_version = mh_smarty_get_version($smarty_generate);

    $output_content_html = '';
    $output_content_txt = '';

    if ($obj->mailBee->is_preview) {
        $smarty_generate->compile_id = $smarty_generate->compile_id . $obj->mailBee->htmlTemplateResource;
    }
    if ($obj->mailBee->template_control) {
        $smarty_generate->compile_id .= 'tc-' . $mail['_iteration'];
    }


    //
    if (!$obj->mailBee->template_control) {
        list($obj,) = mhpi('template_engine_1', $obj, $mail); // -> magic_11
    }

    if ($smarty_version == 2) {
        $viewTemplateMode = $smarty_generate->get_template_vars('viewTemplate'); // smarty 2
        $stripTemplateEditorVarCodes = $smarty_generate->get_template_vars('stripTemplateEditorVarCodes'); // smarty 2
        $stripMainTemplateEditorCodes = $smarty_generate->get_template_vars('stripMainTemplateEditorCodes'); // smarty 2
        $stripEditorVarCodes = $smarty_generate->get_template_vars('stripEditorVarCodes'); // smarty 2
    } elseif ($smarty_version == 3 || $smarty_version == 4) {
        $viewTemplateMode = $smarty_generate->getTemplateVars('viewTemplate'); // smarty 3
        $stripTemplateEditorVarCodes = $smarty_generate->getTemplateVars('stripTemplateEditorVarCodes'); // smarty 3
        $stripMainTemplateEditorCodes = $smarty_generate->getTemplateVars('stripMainTemplateEditorCodes'); // smarty 3
        $stripEditorVarCodes = $smarty_generate->getTemplateVars('stripEditorVarCodes'); // smarty 3
    }
    $viewTemplateMode = ($viewTemplateMode == '') ? false : $viewTemplateMode;
    $stripTemplateEditorVarCodes = ($stripTemplateEditorVarCodes == '') ? false : $stripTemplateEditorVarCodes;
    $stripMainTemplateEditorCodes = ($stripMainTemplateEditorCodes == '') ? false : $stripMainTemplateEditorCodes;
    $stripEditorVarCodes = ($stripEditorVarCodes == '') ? false : $stripEditorVarCodes;

//    error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE & ~E_STRICT & ~E_WARN);
//    error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE & ~E_STRICT & ~E_WARN);
    ini_set('display_errors', 1);

    // put templates in object
    $smarty_tmpl_holder = new stdClass();
    $smarty_tmpl_holder->mh_subjectTemplate = $obj->mailBee->subjectTemplate;
    $smarty_tmpl_holder->mh_subjectTemplate_mtime = $obj->mailBee->subjectTemplate_mtime;
    $smarty_tmpl_holder->mh_preheaderTemplate = $obj->mailBee->preheaderTemplate;
    $smarty_tmpl_holder->mh_preheaderTemplate_mtime = $obj->mailBee->preheaderTemplate_mtime;
    $smarty_tmpl_holder->mh_htmlTemplate = $obj->mailBee->htmlTemplate;
    $smarty_tmpl_holder->mh_htmlTemplate_mtime = $obj->mailBee->htmlTemplate_mtime;
    $smarty_tmpl_holder->mh_txtTemplate = $obj->mailBee->txtTemplate;
    $smarty_tmpl_holder->mh_txtTemplate_mtime = $obj->mailBee->txtTemplate_mtime;
    $smarty_tmpl_holder->mh_htmlBodyTemplate = $obj->mailBee->htmlBodyTemplate;
    $smarty_tmpl_holder->mh_htmlBodyTemplate_mtime = $obj->mailBee->htmlBodyTemplate_mtime;
    $smarty_tmpl_holder->mh_txtBodyTemplate = $obj->mailBee->txtBodyTemplate;
    $smarty_tmpl_holder->mh_txtBodyTemplate_mtime = $obj->mailBee->txtBodyTemplate_mtime;


    $smarty_tmpl_holder->mh_htmlBodyTemplate = mh_preparser($smarty_tmpl_holder->mh_htmlBodyTemplate);
    $smarty_tmpl_holder->mh_htmlTemplate = mh_preparser($smarty_tmpl_holder->mh_htmlTemplate);

    // remove literal tags and add them automatically
    // use [[literal]] .. [[/literal]] for manual setting of literal tags
    $smarty_tmpl_holder->mh_subjectTemplate = mh_smarty_auto_literal($smarty_tmpl_holder->mh_subjectTemplate);
    $smarty_tmpl_holder->mh_htmlTemplate = mh_smarty_auto_literal($smarty_tmpl_holder->mh_htmlTemplate);
    $smarty_tmpl_holder->mh_htmlBodyTemplate = mh_smarty_auto_literal($smarty_tmpl_holder->mh_htmlBodyTemplate);
    $smarty_tmpl_holder->mh_txtTemplate = mh_smarty_auto_literal($smarty_tmpl_holder->mh_txtTemplate);
    $smarty_tmpl_holder->mh_txtBodyTemplate = mh_smarty_auto_literal($smarty_tmpl_holder->mh_txtBodyTemplate);


    if ($strip_editor_codes) {
        $smarty_tmpl_holder->mh_htmlTemplate_mtime = $smarty_tmpl_holder->mh_htmlTemplate_mtime * 2;
        $smarty_tmpl_holder->mh_htmlTemplate = $obj->mailbeez_editor->strip_editor_codes($smarty_tmpl_holder->mh_htmlTemplate);
        $smarty_tmpl_holder->mh_htmlBodyTemplate_mtime = $smarty_tmpl_holder->mh_htmlBodyTemplate_mtime * 2;
        $smarty_tmpl_holder->mh_htmlBodyTemplate = $obj->mailbeez_editor->strip_editor_codes($smarty_tmpl_holder->mh_htmlBodyTemplate);
    }

    if ($stripTemplateEditorVarCodes) {
        $smarty_tmpl_holder->mh_htmlBodyTemplate_mtime = $smarty_tmpl_holder->mh_htmlBodyTemplate_mtime * 2;
        $smarty_tmpl_holder->mh_htmlBodyTemplate = $obj->mailbeez_editor->strip_editor_var_codes($smarty_tmpl_holder->mh_htmlBodyTemplate);
    }

    if ($stripMainTemplateEditorCodes) {
        $smarty_tmpl_holder->mh_htmlTemplate_mtime = $smarty_tmpl_holder->mh_htmlTemplate_mtime * 2;
        $smarty_tmpl_holder->mh_htmlTemplate = $obj->mailbeez_editor->strip_editor_codes($smarty_tmpl_holder->mh_htmlTemplate);
    }

    if ($stripEditorVarCodes) {
        $smarty_tmpl_holder->mh_htmlTemplate_mtime = $smarty_tmpl_holder->mh_htmlTemplate_mtime * 2;
        $smarty_tmpl_holder->mh_htmlTemplate = $obj->mailbeez_editor->strip_editor_var_codes($smarty_tmpl_holder->mh_htmlTemplate);
    }


    if (!$strip_editor_codes) {
        // mark template vars
        $smarty_tmpl_holder->mh_preheaderTemplate = $obj->mailbeez_codes->mark_editor_vars($smarty_tmpl_holder->mh_preheaderTemplate);
    }

    if (!$strip_editor_codes) {
        // mark template vars in editor view
        $smarty_tmpl_holder->mh_htmlBodyTemplate = $obj->mailbeez_codes->mark_editor_vars($smarty_tmpl_holder->mh_htmlBodyTemplate);
    }

    if ($preparse_template_codes) {
        $smarty_tmpl_holder->mh_subjectTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_subjectTemplate);
        $smarty_tmpl_holder->mh_preheaderTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_preheaderTemplate);
        $smarty_tmpl_holder->mh_htmlTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_htmlTemplate);
        $smarty_tmpl_holder->mh_htmlBodyTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_htmlBodyTemplate);
        $smarty_tmpl_holder->mh_txtTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_txtTemplate);
        $smarty_tmpl_holder->mh_txtBodyTemplate = $obj->mailbeez_codes->pre_parse($smarty_tmpl_holder->mh_txtBodyTemplate);
    }

    $smarty_generate->assign('block_url', $obj->buildBlockUrl($mail, $mailbeez_module_path)); // generate block-link

    // todo
    // convert special characters in firstname, lastname
    // or convert all elements of mai


    //$mail['firstname'] = '';
    //$mail['lastname'] = '';

    if ($obj->mailBee->noblock) {
        $smarty_generate->assign('noblock', $obj->mailBee->noblock); // override
    }

    $smarty_generate->assign($mail); // might override noblock setting
    $smarty_generate->assign('module_code', $obj->mailBee->code);
    $smarty_generate->assign($replace_variables_common);

    if (isset($obj->mailBee->styling)) {
        $smarty->assign('stylevars', $obj->mailBee->styling);
    }


    $output_subject = mh_smarty_fetch($smarty_generate, 'subjectTemplate', $smarty_tmpl_holder);
    $output_subject = mh_template_convert($output_subject, array_merge($mail, $replace_variables_common));
    $smarty_generate->assign('subject', $output_subject);
    $output_preheader = mh_smarty_fetch($smarty_generate, 'preheaderTemplate', $smarty_tmpl_holder);
    $output_preheader = mh_template_convert($output_preheader, array_merge($mail, $replace_variables_common));
    $smarty_generate->assign('preheader', $output_preheader);
    if ($viewTemplateMode) {
        $body_content_html = $smarty_tmpl_holder->mh_htmlBodyTemplate;
        $body_content_txt = $smarty_tmpl_holder->mh_txtBodyTemplate;

        // replace common variables "manually" for e.g. preview of images
        $body_content_html = mh_template_bypass_smarty($body_content_html, $replace_variables_common);
        $body_content_txt = mh_template_bypass_smarty($body_content_txt, $replace_variables_common);
    } else {
        $body_content_html = mh_smarty_fetch($smarty_generate, 'htmlBodyTemplate', $smarty_tmpl_holder);
        $body_content_txt = mh_smarty_fetch($smarty_generate, 'txtBodyTemplate', $smarty_tmpl_holder);
        if (mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_COMP_MODE') == 'True') {
            // compatibility mode
            $body_content_html = mh_template_convert($body_content_html, array_merge($mail, $replace_variables_common));
            $body_content_txt = mh_template_convert($body_content_txt, array_merge($mail, $replace_variables_common));
        }

        if (mh_cfg('MAILBEEZ_ANALYTICS_AUTOINSERT_PIX') == 'True') {
            $body_content_html .= $GLOBALS['mh_template_replace_variables_common']['MAILBEEZ_TRACKER_PIX'];
        }
    }

    if (isset($obj->mailBee->styling)) {
        // preparse CSS Styling parameters
        $body_content_html = mh_template_parse_css_tags($body_content_html, $obj->mailBee->styling, array('left' => '/*stylevar:', 'right' => '*/'));
        $smarty_tmpl_holder->mh_htmlTemplate = mh_template_parse_css_tags($smarty_tmpl_holder->mh_htmlTemplate, $obj->mailBee->styling, array('left' => '/*stylevar:', 'right' => '*/'));
        mh_check_template_data($body_content_html, 'mh_template_parse_css_tags 2');
    }
    /*
     *
     * following some encrypted but harmless code which places the copyright line into each email
     *
     * the copyright can be removed with any Pro-Plan
     *
     * The development of MailBeez has been a lot of work
     * and you will very likely increase your revenue by using it
     *
     * It is good to give something back
     *
     * If you have good ideas for mailbeez, lets work together!
     * drop me a line at fairplay@mailbeez.com
     *
     */
    /* following some valid, functional and harmless code which is encoded to protect the module licensing. Please contact license@mailbeez.com if you have any questions */

    @eval(base64_decode('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'));
    if (file_exists(MH_DIR_CONFIG . 'config_editor/template_library/common.css.tpl')) {
        $mailbeez_common_css = file_get_contents(MH_DIR_CONFIG . 'config_editor/template_library/common.css.tpl');
        if (isset($obj->mailBee->styling)) {
            // preparse CSS Styling parameters
            $mailbeez_common_css = mh_template_parse_css_tags($mailbeez_common_css, $obj->mailBee->styling, array('left' => '/*stylevar:', 'right' => '*/'));
        }

        $smarty_generate->assign('template_source', $mailbeez_common_css);
        $mailbeez_common_css = $smarty_generate->fetch(MH_DIR_CONFIG . 'config_editor/classes/smarty_eval.tpl');

    } else {
        $mailbeez_common_css = '';
    }


    mh_check_template_data($output_content_html, 'init');

    // preparse tags in CSS with [##$var##] delimiters
    $output_content_html = mh_template_parse_css_tags($output_content_html, array('MAILBEEZ_COMMON_CSS' => $mailbeez_common_css));

    // complex elements: bypass issue with smarty variables in style
    $output_content_html = mh_template_parse_css_tags($output_content_html, array(
        'STYLEBLOCK_START' => '<style type="text/css">',
//        'STYLEBLOCK_CSS_OPEN' => '{literal}{{/literal}',
//        'STYLEBLOCK_CSS_CLOSE' => '{literal}}{/literal}',
        'STYLEBLOCK_CSS_OPEN' => '{',
        'STYLEBLOCK_CSS_CLOSE' => '}',
        'STYLEBLOCK_END' => '</style>',
    ));


    mh_check_template_data($output_content_html, 'mh_template_parse_css_tags 1');


    if (isset($obj->mailBee->styling)) {
        // preparse CSS Styling parameters
        $output_content_html = mh_template_parse_css_tags($output_content_html, $obj->mailBee->styling, array('left' => '/*stylevar:', 'right' => '*/'));
        mh_check_template_data($output_content_html, 'mh_template_parse_css_tags 2');
    }

    // preparse tags in CSS with [##$var##] delimiters
    $output_content_html = mh_template_parse_css_tags($output_content_html, $replace_variables_common);

//    $output_content_html = mh_template_parse_css_tags($output_content_html, array_merge($mail, $replace_variables_common));

    // process inline styles
    // replace & with &amp; (but not &amp; with &amp;amp;)
    // to avoid DOM warnings

    mh_check_template_data($output_content_html, 'mh_template_parse_css_tags 3');


    // clean up
    $output_content_html = str_replace('pxpx', 'px', $output_content_html);

    $output_content_html = preg_replace('/&(?![A-Za-z0-9#]{1,7};)/', '&amp;', $output_content_html);

    mh_check_template_data($output_content_html, 'clean up 1');


    // thanks to markdown
    // Remove UTF-8 BOM and marker character in input, if present.
    $output_content_html = preg_replace('{^\xEF\xBB\xBF|\x1A}', '', $output_content_html);
    mh_check_template_data($output_content_html, 'clean up 2');

    // moved to the end of the email generation process
    //$output_content_html = mh_template_emogrify($output_content_html);

    $output_content_html = mh_template_outlook_helper($output_content_html);
    mh_check_template_data($output_content_html, 'mh_template_outlook_helper');


    $output_subject = strip_tags($output_subject); // remove html tags from subject

    // convert complete subject

    if (!(isset($mail['subject_plain']) && $mail['subject_plain'] == true)) {
        if (mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENCODE_SUBJECT') == 'True') {
            $output_subject = mh_convert_characters_subject_utf_8($output_subject);
        }
    }


    if ($output_content_txt == '') {
        // auto generate txt version if empty
        $h2t = new html2text($output_content_html);
        $output_content_txt = $h2t->get_text();
    }

    // preserve links
    $output_content_txt = preg_replace("#<a href=\"(([a-zA-Z]+://)([a-zA-Z0-9%.;:/=+_-]*[?]+[a-zA-Z0-9&%.;:/=+_-]*))\"#", "$1" . "\n<a", $output_content_txt);


    // make sure txt version is not containing any html
    $output_content_txt = strip_tags($output_content_txt);

    // remove multiple empty lines
//    $output_content_txt = preg_replace("/[\r\n]+/", "\n", $output_content_txt);
//    $output_content_txt = preg_replace("/[\n]+/", "\n", $output_content_txt);

// playmoa - issue: empty lines
//    $output_content_txt = preg_replace('/(?:(?:\r\n|\r|\n)\s*){2}/s', "\n\n", $output_content_txt);


    // replace quotes in content
    // depending on context

    $quote_substitute = defined('mailbeez_editor::QUOTE_SUBSTITUTE')
        ? \mailbeez_editor::QUOTE_SUBSTITUTE
        : '#QUOTE#';
    if ($preparse_template_codes) {
        $output_content_html = str_replace($quote_substitute, '"', $output_content_html);
    } else {
        $output_content_html = str_replace($quote_substitute, '"&quot;"', $output_content_html);
    }

    return array($output_subject, $output_content_html, $output_content_txt, $output_preheader);
}


function mh_smarty_auto_literal($content)
{
    // remove literal
    $content = str_replace('{literal}', '', $content);
    $content = str_replace('{/literal}', '', $content);

    // and insert it from scratch
    $content = preg_replace('#(<style[^>]*>)([^<]*)(</style>)#', "$1{literal}$2{/literal}$3", $content);

    // doing some fixing as well - shouldn't be here, but for now...

    // fixing ' inside smarty code
    $content = str_replace('&#39;', "'", $content);


    // fixing ' inside smarty code
    $content = str_replace('&rsquo;', "'", $content);

    // fixing " inside smarty code
    $content = str_replace('&quot;', '"', $content);


    // fixing - inside smarty code
    $content = str_replace('&ndash; ', '-', $content);

    return $content;
}

function mh_smarty_fix($content)
{
    // smarty 4 incompatibility

    $content = preg_replace('#value="\[VAR_SELECT data-source="(.*)" #', "value\"[VAR_SELECT data-source='$1'", $content);
    // $content = str_replace('value="[VAR_SELECT data-source="display_mode" ', 'value="[VAR_SELECT data-source=\'display_mode\'', $content);
    return $content;
}

function mh_template_outlook_helper($output_content_html)
{
    // outlook requires some special treatment....


    $output_content_html_input = $output_content_html;

    // find all images
    if (preg_match_all('/<img[^>]+>/ims', $output_content_html, $matches)) {
        foreach ($matches[0] as $img_match) {
            // for each image find width and heights from style attribute
            preg_match('/[^-]width[: ]+([0-9%]+)/', $img_match, $width);
            preg_match('/[^-]height[: ]+([0-9%]+)/', $img_match, $height);
            $img_match_new = $img_match;
            if (!preg_match('/(width|height)=["\'\d%\s]+/ims', $img_match)) {
                // if not set, add width and height attributes


                // unwanted effect
//                if (!$height[1]) {
//                    $height[1] = '100%';
//                }

                $img_match_new = str_replace('>', ' width="' . mh_arr_val($width, 1) . '" height="' . mh_arr_val($height, 1) . '">', $img_match);
            }
            // Replace with result within html
            $output_content_html = str_replace($img_match, $img_match_new, $output_content_html);
        }
    }
    // fix invalid html causing broken layouts in outlook e.g. width="600px" => width="600"
    $output_content_html = preg_replace('/"([0-9]+)px"/', '"$1"', $output_content_html);

    //add !important to inline style colors
    // <span style="color:#FF0000;"> -> <span style="color:#FF0000 !important;">
    // <span style="background-color:#FF0000;"> -> <span style="background-color:#FF0000 !important;">
    $output_content_html = preg_replace('/<span style="([^>]*)color:[\s]?#([0-9a-fA-F]*);(.?)">/ims', '<span style="$1color:#$2 !important;$3">', $output_content_html);


    // remove all lines with up to 10 only empty cells to avoid layout issues on some email clients
    $regex_row = '<tr[^>]*>([^>]*>[\s]*?<\/td[^<]*){0,10}<\/tr>';
    $output_content_html = preg_replace('/' . $regex_row . '/sm', '', $output_content_html);

    // remove empty lines before table tag
    $regex_table = '<td ([^>]*)>\s*?<table';
    $output_content_html = preg_replace('/' . $regex_table . '/sm', '<td $1><table', $output_content_html);

    // add <font> tag into other tags to ensure font color
    // *? non-greedy match
    $regex_font = '(<(h1|h2|h3)(?! data-rawtag=\'true\')[^>]*>)(.*?)(<\/\2>)';
    $output_content_html = preg_replace('/' . $regex_font . '/ims', '$1<font >$3</font>$4', $output_content_html);

    // outlook 120 dpi hell...
    // https://litmus.com/community/discussions/151-mystery-solved-dpi-scaling-in-outlook-2007-2013
    // https://www.emailonacid.com/blog/article/email-development/dpi_scaling_in_outlook_2007-2013

    // make sure all tables / td with fixed width have both attribute and style setting set

    // todo


    if (!function_exists('mh_fixOutlookTable')) {
        function mh_fixOutlookTable($match)
        {
            $str = $match[0];
            $str_new = $str;

            // check if style="width: 123px" or style="width: 50%"
            preg_match('/width[: ]+([0-9%]+)/', $str, $css_width);

            // check if width="123" or width="50%"
            preg_match('/width[="]+([0-9%]+)"/', $str, $attr_width);

            $css_add = '';
            $attr_add = '';
            if (sizeof($css_width) == 0 && sizeof($attr_width) > 0) {

                if (!stristr($attr_width[1], '%')) {
                    // skip for %
                    $css_add = 'width: ' . $attr_width[1] . 'px; ';
                    if (stristr($str, 'style="')) {
                        $str_new = str_replace('style="', 'style="' . $css_add, $str_new);
                    }
                };
            }
            if (sizeof($css_width) > 0 && sizeof($attr_width) == 0) {
                $attr_add = 'width="' . $css_width[1] . '" ';
                $str_new = str_replace('>', $attr_add . '>', $str_new);
            }
            return $str_new; //str_replace($str, $str_new, $str);

        }
    }

    $regex_styles = '<(table|td)[^>]+width[^>]+>';
    $output_content_html = preg_replace_callback('/' . $regex_styles . '/', 'mh_fixOutlookTable', $output_content_html);


//echo $output_content_html; mh_exit();


    // failure backup
    if (trim($output_content_html) == '') {
        return $output_content_html_input;
    }

    return $output_content_html;
}

function mh_preparser($string)
{
    // fix outlook issue with content block
    // fix faulty style in content block element

    /*
    [EDIT_COMPLEX title="Content Block"

    replace:"mso-line-height-rule:exactly;line-height: 0 !important;" -> ""

    [/EDIT_COMPLEX]

    */

    preg_match_all('#\[EDIT_COMPLEX title="Content Block" (.*)\[\/EDIT_COMPLEX\]#ismU', $string, $matches, PREG_SET_ORDER);

    $replace = array();

    if (count($matches) > 0) {
        foreach ($matches as $m) {
            $s = $m[0];
            $search[] = $s;
            $r = $s;
            $r = str_replace('mso-line-height-rule:exactly;line-height: 0 !important;', '', $r);
            $r = str_replace('mso-line-height-rule: exactly; line-height: 0;', '', $r);
            $replace[] = $r;
        }
        $string = str_replace($search, $replace, $string);
    }
    return $string;
}

if (!function_exists('mh_convert_characters_subject_utf_8')) {

    function mh_convert_characters_subject_utf_8($subject)
    {
        // very painful topic ahead!!!


        // arrrgh...
        // UTF-8 encoding of subject
        // http://stackoverflow.com/questions/341708/how-to-handle-utf-8-email-headers-like-subject-using-ruby
        // http://ncona.com/2011/06/using-utf-8-characters-on-an-e-mail-subject/
        //
        // doesnt work with sending through gmail reading on thunderbird, but shows on iphone
        // seems to work

        //$subject = str_replace('&amp;', '&', $subject);
        //$subject = html_entity_decode($subject);

        //    $subject = preg_replace_callback("/(&#[0-9]+;)/", create_function('$m', 'return mb_convert_encoding($m[1], "UTF-8", "HTML-ENTITIES");' ), $subject);
        //    $subject = preg_replace_callback("/(&#[0-9]+;)/", create_function('$m', 'html_entity_decode(mb_convert_encoding($m[1], "UTF-8", "UTF-8"), ENT_COMPAT, "UTF-8");' ), $subject);

        //    $subject = html_entity_decode(mb_convert_encoding($subject, 'UTF-8', 'UTF-8'), ENT_COMPAT, "UTF-8");

        // todo
        // automatic db encoding detection
        if (false) {
            // works at valentin for all special characters / languages
            // PHP 8 incompatible - but not used anway
            // $subject = preg_replace_callback("/(&#[0-9]+;)/", create_function('$m', 'return mb_convert_encoding($m[1], "UTF-8", "HTML-ENTITIES");'), $subject);
            return "=?utf-8?B?" . base64_encode($subject) . "?=";
        } else {
            // works with � ...
            return mb_encode_mimeheader($subject, 'UTF-8');
        }
    }
}


function mh_convert_characters_table()
{
    // todo
    // http://php.net/manual/en/function.get-html-translation-table.php

    $convert_array = array('ï¿€' => '&Agrave;', 'ï¿ ' => '&agrave;', 'ï¿?' => '&Aacute;', 'ï¿¡' => '&aacute;', 'ï¿‚' => '&Acirc;', 'ï¿¢' => '&acirc;', '?' => '&Atilde;', '?' => '&atilde;', 'ï¿„' => '&Auml;', 'ï¿¤' => '&auml;', 'ï¿…' => '&Aring;', 'ï¿¥' => '&aring;', 'ï¿†' => '&AElig;', 'ï¿¦' => '&aelig;', 'ï¿‡' => '&Ccedil;', 'ï¿§' => '&ccedil;', '?' => '&ETH;', '?' => '&eth;', 'ï¿ˆ' => '&Egrave;', 'ï¿¨' => '&egrave;', 'ï¿‰' => '&Eacute;', 'ï¿©' => '&eacute;', 'ï¿?' => '&Ecirc;', 'ï¿ª' => '&ecirc;', 'ï¿‹' => '&Euml;', 'ï¿«' => '&euml;', '?' => '&Igrave;', '?' => '&igrave;', 'ï¿?' => '&Iacute;', 'ï¿­' => '&iacute;', 'ï¿?' => '&Icirc;', 'ï¿®' => '&icirc;', 'ï¿?' => '&Iuml;', 'ï¿¯' => '&iuml;', 'ï¿‘' => '&Ntilde;', 'ï¿±' => '&ntilde;', '?' => '&Ograve;', '?' => '&ograve;', 'ï¿“' => '&Oacute;', 'ï¿³' => '&oacute;', 'ï¿”' => '&Ocirc;', 'ï¿´' => '&ocirc;', '?' => '&Otilde;', '?' => '&otilde;', 'ï¿–' => '&Ouml;', 'ï¿¶' => '&ouml;', 'ï¿˜' => '&Oslash;', 'ï¿¸' => '&oslash;', 'ï¾Œ' => '&OElig;', 'ï¾œ' => '&oelig;', 'ß' => '&szlig;', '?' => '&THORN;', '?' => '&thorn;', 'ï¿™' => '&Ugrave;', 'ï¿¹' => '&ugrave;', 'ï¿?' => '&Uacute;', 'ï¿º' => '&uacute;', 'ï¿›' => '&Ucirc;', 'ï¿»' => '&ucirc;', 'ï¿œ' => '&Uuml;', 'ï¿¼' => '&uuml;', '?' => '&Yacute;', '?' => '&yacute;', 'ï¾Ÿ' => '&Yuml;', 'ï¿¿' => '&yuml;');
    return $convert_array;
}

if (!function_exists('mh_convert_characters')) {

    function mh_convert_characters($content)
    {
        // purpose of this function is to replace characters with their entity fully controlled

        // todo
        // automatic db encoding detection
        if (false) {
            // works at valentin for all special characters / languages
            return $content;
        } else {
            $convert_array = mh_convert_characters_table();

            // somehow special characters get lost in the code, so lets reconstruct them from their html entity
            $convert_array_trans = array();
            foreach ($convert_array as $key => $value) {
                $convert_array_trans[html_entity_decode($value)] = $value;
            }

            $convert_values = array_values($convert_array_trans);
            $convert_keys = array_keys($convert_array_trans);
            $content = str_replace($convert_keys, $convert_values, $content);

            return $content;
        }
    }
}

function mh_check_template_data($content, $step)
{
    if (!trim($content)) {

        $msg = "*****\n";
        $msg .= "empty content $content";
        $msg .= "Step:" . $step;
        $msg .= "\n";
//        echo $msg . "<br>";
        mh_template_engine_error_log($msg);
    }
}

function mh_template_engine_error_log($msg)
{
    $filename = MH_TEMPLATE_ENGINE_LOGFILE;
    $stream = fopen($filename, 'a');
    $string = "[" . date("Y/m/d h:i:s", time()) . "] " . $msg;
    fwrite($stream, $string . PHP_EOL);
    fclose($stream);
}

function mh_template_emogrify($output_content_html)
{

    // should not happen - avoid exception thrown by emogrify();
    if ($output_content_html === '') {
        return $output_content_html;
    }

    list($output_content_html, $m) = mhpi('template_engine_2', $output_content_html);
    mh_check_template_data($output_content_html, 'template_engine_2');


    if (mh_cfg('MAILBEEZ_CONFIG_TEMPLATE_ENGINE_EMOGRIFY') == 'True') {
        // engine Emogrifier
        $output_content_html = mh_convert_characters($output_content_html);
        mh_check_template_data($output_content_html, 'mh_convert_characters');

        // http://classes.verkoyen.eu/css_to_inline_styles/docs
        // require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/css_to_inline_styles.php');
        // http://www.pelagodesign.com/sidecar/emogrifier/
        require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/mailbeez_emogrifier_wrapper.php');

        $emogrifier = new mh_Emogrifier($output_content_html);
        try {

            $output_content_html = $emogrifier->emogrify();
        } catch (InvalidArgumentException $e) {
//            print_r($e); exit();
            // ignore for now...
            // todo - handle exception
        }
        $output_content_html = str_replace('</title>', "</title>\n" . $m, $output_content_html);
        mh_check_template_data($output_content_html, 'emogrifier');

        // convert style font-color to attribute for font tag
        if (preg_match_all('/<font [^>]+>/ims', $output_content_html, $matches)) {
            foreach ($matches[0] as $font_match) {
                // for each font tag find color from style attribute
                preg_match('/color: (#[a-f0-9]+)/', $font_match, $color);
                $font_match_new = $font_match;
                if (isset($color[1])) {
                    if (!preg_match('/color="#[a-f0-9]+"/ims', $font_match)) {
                        // if not set, add color attribute
                        $font_match_new = str_replace('>', ' color="' . $color[1] . '">', $font_match);
                    }
                }
                // Replace with result within html
                $output_content_html = str_replace($font_match, $font_match_new, $output_content_html);
            }
        }

    }

    // remove !important from inline styles as this breaks some cases in outlook

    if (!function_exists('mh_replaceImportant')) {
        function mh_replaceImportant($match)
        {
            return str_replace(' !important', '', $match[0]);
        }
    }

    $regex_styles = 'style="[^"]*"';
    $output_content_html = preg_replace_callback('/' . $regex_styles . '/', 'mh_replaceImportant', $output_content_html);

    /*

    if (defined('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_STATUS') && (mh_get_conf('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_STATUS') == 'True')) {

        // moved from filter_layout_optimizer
        if (defined('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_TABLEFIX') && MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_TABLEFIX == 'True') {
            $output_content_html = preg_replace('#<tr [^>]*>\s*<td [^>]*><img [^>]*></td>\s*<td>\s*(<!--\s*-->\s*)?\s*</td>\s*</tr>#', "", $output_content_html);
        }
        if (defined('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_COMMENT') && MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_COMMENT == 'True') {
            // remove empty comments
            $output_content_html = preg_replace('#\s*(<!--\s*-->\s*)\s*#', " ", $output_content_html);
            $output_content_html = preg_replace('#\s*(<!---->\s*)\s*#', " ", $output_content_html);

            // remove comments
            $output_content_html = preg_replace('#<!--[^>]*-->#', " ", $output_content_html);
        }
        if (defined('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_WRAP') && MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_WRAP == 'True') {
            $output_content_html = wordwrap($output_content_html, 76, "\n");
        }
        if (defined('MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_WRAP') && MAILBEEZ_FILTER_LAYOUT_OPTIMIZER_WS == 'True') {
            $output_content_html = preg_replace('/\s\s+/', " ", $output_content_html);
            $output_content_html = str_replace("\n\n\n", "\n", $output_content_html);
            $output_content_html = str_replace("\n\n", "\n", $output_content_html);
        }
    }

    */

    return $output_content_html;
}