<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

mh_define('MAILBEEZ_CONFIG_ANALYTICS_PIWIK_STATUS', 'True');
mh_define('MAILBEEZ_MAILHIVE_PIWIK_ENABLED_ICON', \configbeez::SVG_ANALYTICS_ICON);

class config_analytics_piwik extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_analytics_piwik';
        $this->module = 'config_analytics_piwik'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_ANALYTICS_PIWIK_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_ANALYTICS_PIWIK_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/piwik.png';
        $this->icon = '../../common/images/icon_piwik.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4.2;
        $this->enabled = ((mh_cfg('MAILBEEZ_MAILHIVE_PIWIK_ENABLED') == 'True') ? true : false);
        $this->status_key = 'MAILBEEZ_CONFIG_ANALYTICS_PIWIK_STATUS';

        $this->documentation_key = $this->module; // leave empty if no documentation available
        $this->documentation_root = 'https://www.mailbeez.com/documentation/configbeez/';
        $this->beez_ui_ready = true;
        $this->group = self::GROUP_ANALYTICS;

        $this->_blueprint();

    }

    function config_analytics_piwik()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        return array('MAILBEEZ_MAILHIVE_PIWIK_ENABLED', 'MAILBEEZ_MAILHIVE_PIWIK_REWRITE_MODE', 'MAILBEEZ_MAILHIVE_PIWIK_REWRITE_FORMAT', 'MAILBEEZ_MAILHIVE_PIWIK_CAMPAIGN');
    }

    function install()
    {
        return false;
    }

}

