<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_api extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_api';
        $this->module = 'config_api'; // same as folder name
        $this->version = 4.0; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_API_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_API_TEXT_DESCRIPTION');
//        $this->description_image = '../../common/images/icon_ma_64.png';
//        $this->icon = '../../common/images/icon_ma.png';
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4;
        $this->status_key = 'MAILBEEZ_API_STATUS';

        $this->enabled = mh_cfg('MAILBEEZ_API_STATUS') == 'True';

        // self installing
        if (!mh_cfg($this->status_key)) {
            $this->install();
        } elseif (mh_cfg('MAILBEEZ_API_STATUS') == 'True') {
            $this->admin_action_plugins_path = MH_DIR_CONFIG;
            $this->admin_action_plugins = 'showdocs.php';
            $this->check_update();
        }


    }

    function config_api()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }


    // installation methods

    function keys()
    {
        if (mh_cfg('MAILBEEZ_API_STATUS') == 'True') {
        }
        $keys_array = array('MAILBEEZ_API_STATUS', 'MAILBEEZ_API_KEY');
        return $keys_array;
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Activate API',
            'configuration_key' => 'MAILBEEZ_API_STATUS',
            'configuration_value' => 'False',
            'configuration_description' => 'Choose True to activate API',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));
        mh_insert_config_value(array('configuration_title' => 'Api key',
            'configuration_key' => 'MAILBEEZ_API_KEY',
            'configuration_value' => md5(time()),
            'configuration_description' => 'API key',
        ));
    }
}

