<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_automatic extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_automatic';
        $this->module = 'config_automatic'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_AUTOMATIC_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_AUTOMATIC_TEXT_DESCRIPTION_LONG');
        if (mh_cfg('MAILBEEZ_CRON_INSTALLED') ||
            file_exists(mh_cfg('MH_DIR_CONFIG') . 'config_cron_simple.php') ||
            file_exists(mh_cfg('MH_DIR_CONFIG') . 'config_cron_advanced.php')
        ) {
            $this->hidden = true;
        } else {
            $this->icon = '../../common/images/lock.png';
        }
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module


        $this->sort_order = 7;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True';
        //$this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        //$this->admin_action_plugins = 'dashboard_modules.php';

        $this->documentation_key = 'config'; // leave empty if no documentation available
        $this->documentation_root = 'https://www.mailbeez.com/documentation/installation/';

        $this->display_as_submodule_of = 'config';

        $this->is_configurable = false;
    }

    function config_automatic()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        if (mh_cfg('MAILBEEZ_THROTTLING_RATE')) {
            return array('MAILBEEZ_THROTTLING_RATE', 'MAILBEEZ_THROTTLING_MAX');
        }
    }

    function install()
    {
        return false;
    }

}

?>
