<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2015 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */


require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');


class config_block extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_block';
        $this->module = 'config_block'; // same as folder name
        $this->version = '3.00'; // float value
        $this->required_mb_version = 2.99; // required mailbeez version
        $this->hidden = true;
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 5;
    }

    function process_block($module, $customers_id, $email_address, $source = 0, $docheck = true, $mode = 'prod', $behaviour = 'Global', $show_output = true, $request_confirmation = false)
    {
        $result = null;

        if ($request_confirmation) {
            $action = 'block_confirm';

//            echo "request confirmation";
//            exit();

        } else {
            $mailbeez_mailer = new mailbeez_mailer($this);
            $result = $mailbeez_mailer->block($module, $customers_id, $email_address, $source, $docheck, $mode, $behaviour);
            $action = 'block';
        }

        if ($show_output) {
            return $this->show($result, $module, $email_address, $action, $behaviour, $customers_id);
        } else {
            return $result;
        }
    }

    function process_unblock($module, $customers_id, $email_address, $source = 0, $docheck = true, $mode = 'prod', $behaviour = 'Global', $show_output = true)
    {
        $mailbeez_mailer = new mailbeez_mailer($this);
        $result = $mailbeez_mailer->unblock($module, $customers_id, $email_address, $source, $docheck, $mode, $behaviour);

        if ($show_output) {
            return $this->show($result, $module, $email_address, 'unblock', $behaviour, $customers_id);
        } else {
            return $result;
        }
    }

    function show($result, $module, $email_address, $action, $behaviour, $customers_id)
    {
        $smarty = new mh_Smarty;
        $smarty->setTemplateDir(MH_DIR_CONFIG . 'config_block/templates/');
        $smarty->setCompileCheck(true);
        $smarty->setCompileId('block');
        $smarty->setConfigDir(MH_DIR_CONFIG . 'config_block/languages/');

        // lngrefactor
        if (file_exists($smarty->getConfigDir(0) . $_SESSION['language'] . '.conf')) {
            $smarty->assign('language', $_SESSION['language']);
        } else {
            $smarty->assign('language', 'english');
        }

        $module_action = $module;

        if ($module == 'ALL') {
            $module_action = 'service_handler_block_all';
        }

        $unblock_url = MAILBEEZ_MAILHIVE_URL_DIRECT . '?ma=unblock&m=' . $module_action . '&mp=' . mh_get('mp')
;
        $block_confirm_url = MAILBEEZ_MAILHIVE_URL_DIRECT . '?ma=block_confirmed&m=' . $module_action . '&mp=' . mh_get('mp')
;

        $smarty->assign('mode', $action);
        $smarty->assign('behaviour', $behaviour);
        $smarty->assign('result', $result);
        $smarty->assign('unblock_url', $unblock_url);
        $smarty->assign('block_confirmed_url', $block_confirm_url);
        $smarty->assign('email_address', $email_address);
        $smarty->assign('customers_id', $customers_id);
        $smarty->assign('options', false);

        if (file_exists(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'mailbeez/mb_newsletter/classes/mb_newsletter_categories.php')
            && mh_cfg('MAILBEEZ_NEWSLETTER_STATUS')
            && mh_cfg('MAILBEEZ_NEWSLETTER_STATUS') == 'True') {
            require_once(mh_cfg('MH_DIR_FS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'mailbeez/mb_newsletter/classes/mb_newsletter_categories.php');
            if (method_exists('mb_newsletter_categories', 'get_options_include')) {
                $smarty->assign('options', mb_newsletter_categories::get_options_include($email_address, $customers_id));
            }
        }


        $smarty->assign('module', $module);


        // lngrefactor
        $user_lang = $_SESSION['language'];
        $user_language_id = $_SESSION['languages_id'];

        if (mh_smarty_template_exists($smarty, 'webview_' . $user_lang . '.tpl.html')) {
            $output = $smarty->fetch('webview_' . $user_lang . '.tpl.html');
        } elseif (mh_smarty_template_exists($smarty, 'webview_' . $user_language_id . '.tpl.html')) {
            $output = $smarty->fetch('webview_' . $user_language_id . '.tpl.html');
        } elseif (mh_smarty_template_exists($smarty, 'webview.tpl.html')) {
            $output = $smarty->fetch('webview.tpl.html');
        } else {
            $output = $smarty->fetch('default_webview.tpl.html');
        }

        return $output;
    }
}