<?php


function trackBounceByAddress($bounced_email_address)
{

    // prepare for email addresses like test'@gmail.com

    $bounced_email_address = mh_db_input($bounced_email_address);

    // check against written bounces
    $sql_query_raw = "select id from " . TABLE_MAILBEEZ_BOUNCE . " where customers_email = '" . $bounced_email_address . "'";
    $sql_query = mh_db_query($sql_query_raw);

    if (mh_db_num_rows($sql_query) > 0) {
        // already processed
        //echo "$bounced_email_address already processed <hr>";
        return false;
    }

    // try to match email with mailbeez tracking data
    $sql_query_raw = "select autoemail_id, module, customers_email, customers_id, bounce_status
                                from " . TABLE_MAILBEEZ_TRACKING . "
                                where customers_email = '" . $bounced_email_address . "'
                                    and bounce_status = ''
                                order by autoemail_id DESC
                                limit 1";

    $sql_query = mh_db_query($sql_query_raw);

    // found matching entry
    if (mh_db_num_rows($sql_query) > 0) {
        $query = mh_db_fetch_array($sql_query);
        $sql_data_array = array('autoemail_id' => $query['autoemail_id'],
            'customers_email' => $query['customers_email'],
            'customers_id' => $query['customers_id'],
            'module' => $query['module'],
            'date_bounce' => 'now()',
            'bounce_type' => 'H'
        );

        mh_db_perform(TABLE_MAILBEEZ_BOUNCE, $sql_data_array);

        /*
        if (mh_get_conf('MAILBEEZ_BOUNCEHIVE_UNSUBSCRIBE') == 'True') {
            mailbeez_bounce_unsubscribe($query['customers_id'], 'H');
        }
        */

        if (mh_cfg('MAILBEEZ_BOUNCEHIVE_MSG_LOG') == 'True') {
            $sql_data_array = array('autoemail_id' => $query['autoemail_id'],
                'bounce_msg' => 'Mlbz Hard Bounce',
            );
            mh_db_perform(TABLE_MAILBEEZ_BOUNCE_MSG_LOG, $sql_data_array);
        }

        mh_db_query("update " . TABLE_MAILBEEZ_TRACKING . "
                                set bounce_status = 'H'
                                where autoemail_id = '" . $query['autoemail_id'] . "'");

        // echo "$bounced_email_address matched to mailbeez email <hr>";
        return true;

    } else {
        // add bounce data for unknown mail

        //echo "handling bounced on unknown mail<hr>";
        $sql_query_raw = "select customers_id, customers_email_address
                                    from " . TABLE_CUSTOMERS . "
                                    where customers_email_address = '" . $bounced_email_address . "'";

        $sql_query = mh_db_query($sql_query_raw);

        if (mh_db_num_rows($sql_query) > 0) {

            // write for all matching customer ids
            while ($query = mh_db_fetch_array($sql_query)) {
                $sql_data_array = array('autoemail_id' => -1,
                    'customers_email' => $query['customers_email_address'],
                    'customers_id' => $query['customers_id'],
                    'module' => 'n/a',
                    'date_bounce' => 'now()',
                    'bounce_type' => 'H'
                );

                mh_db_perform(TABLE_MAILBEEZ_BOUNCE, $sql_data_array);


                /*
                if (mh_get_conf('MAILBEEZ_BOUNCEHIVE_UNSUBSCRIBE') == 'True') {
                    mailbeez_bounce_unsubscribe($query['customers_id'], 'H');
                }
                */

            }
            //echo "$bounced_email_address matched to customer <hr>";
            return true;

        } else {
            // track all other email addresses as well
            $sql_data_array = array('autoemail_id' => -1,
                'customers_email' => $bounced_email_address,
                'customers_id' => -1,
                'module' => 'n/a',
                'date_bounce' => 'now()',
                'bounce_type' => 'H'
            );

            mh_db_perform(TABLE_MAILBEEZ_BOUNCE, $sql_data_array);
            //echo "$bounced_email_address unknown, tracked <hr>";
            return true;
        }
    }

}