<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

require_once(MH_DIR_CONFIG . 'config_cloudbeez/classes/api_cloudbeez_consumer.php');

// no caching here
list($show_select_package, $show_waiting_info, $show_install_package, $show_update_package, $show_update_package_ok, $show_invalid_license, $show_api_error) = cloudbeez_status_handler::getStatus(false);
list($select_package, $install_package, $update_package) = cloudbeez_status_handler::getActionUrls();


$cloudbeez_select_package_button = mb_admin_button($select_package, mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_SELECT_PACKAGE_BUTTON'), '', 'link', 'button', '', 'document', 'iframe');
$cloudbeez_install_package_button = mb_admin_button($install_package, mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_INSTALL_PACKAGE_BUTTON'), '', 'popup', 'button', '', 'document', 'iframe');
$cloudbeez_reinstall_package_button = mb_admin_button($install_package, mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_REINSTALL_PACKAGE_BUTTON'), '', 'popup', 'button', '', 'document', 'iframe');
$cloudbeez_update_package_button = mb_admin_button($update_package, mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_UPDATE_PACKAGE_BUTTON'), '', 'popup', 'button', '', 'document', 'iframe');

$cloudbeez_button = '';

if ($show_install_package) {
    $cloudbeez_button = $cloudbeez_install_package_button;
} elseif ($show_select_package) {
    $cloudbeez_button = $cloudbeez_select_package_button;
} elseif ($show_waiting_info) {
    $cloudbeez_button = mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_WAIT_IPN');
} elseif ($show_update_package) {
    $cloudbeez_button = $cloudbeez_update_package_button;
} elseif ($show_update_package_ok) {
    $cloudbeez_button = $cloudbeez_reinstall_package_button;
    $cloudbeez_button .= '<br><br>';
    $cloudbeez_button .= mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_OK');
}


if ($show_api_error) {
    $cloudbeez_button = mh_lng('MAILBEEZ_MAILHIVE_CLOUDLOADER_API_ERROR');
}

$subscriptions = cloudBeezApiConsumer::getSubscriptionInfoHtml();

$status_msg = '';


if ($subscriptions) {
    $contents[] = array('text' => '<div class="mb_action_box">
                <div class="mb_action_box headline">' . mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_INFO') . '</div>
                <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_INFO_TEXT') . '</div>
                <div class="mb_action_box text">' . $subscriptions . '</div>
                </div>');
}


$contents[] = array('text' => '
    <div class="mb_action_box headline">' . mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_ACTION_HEADLINE') . '</div>' .
    '<div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_CLOUDBEEZ_ACTION_TEXT') . '<br><br></div>' .
    '<div class="mb_action_box buttons" style="clear: both"><div align="center">' .

    $cloudbeez_button .

    '</div></div>' .
    '<div class="mb_action_box text"><div align="center">' . $status_msg . '</div></div> ');
