<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

require_once(MH_DIR_CONFIG . 'config_customer_insight.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/context_date.php');


class mh_insight_admin
{
    var $email;
    var $name;
    var $language;
    var $language_id;
    var $image;


    function __construct()
    {
        return $this->init_admin_info();
    }

    function init_admin_info()
    {
        list($email, $name) = $this->get_admin_info();
        return $this->set_admin_info($email, $name);
    }

    function set_admin_info($email, $name)
    {
        $this->email = $email;
        $this->name = $name;
        $this->language = ($_SESSION['languages_id'] == '') ? '2' : $_SESSION['languages_id'];
        if ($this->language_id == '') $this->language_id = (int)$_SESSION['languages_id'];
        $this->set_admin_image();
        return true;
    }


    function get_admin_info()
    {

        $email = '';
        $name = '';

        // enable hook for custom function
        if (function_exists('mh_get_admin_info')) {
            return mh_get_admin_info();
        }

        switch (MH_PLATFORM) {
            case 'oscommerce':
            case 'creloaded':
            case 'digistore':

                if (isset($_SESSION['admin'])) {
                    $email = $_SESSION['admin']['username'];
                    $name = $_SESSION['admin']['username'];
                } elseif (isset($_SESSION['login_id'])) {
                    // holbi true loaded
                    $query_sql = "SELECT admin_firstname, admin_lastname, admin_email_address
                                    FROM " . TABLE_ADMIN . "
                                    WHERE admin_id = '" . mh_db_input($_SESSION['login_id']) . "'";
                    $query = mh_db_query($query_sql);
                    if (mh_db_num_rows($query) == 0) {
                        return false;
                    }
                    $admin_data = mh_db_fetch_array($query);

                    $email = $admin_data['admin_email_address'];
                    $name = $admin_data['admin_firstname'] . ' ' . $admin_data['admin_lastname'];
                }


                break;
            case 'zencart':

                // zencart 1.3 compatibility
                if (!function_exists('zen_get_users')) {
                    function zen_get_users($limit = '')
                    {
                        global $db;
                        $retVal = array();
                        $sql = 'SELECT a.* FROM ' . TABLE_ADMIN . ' a ';
                        if ($limit != '') {
                            $sql .= ' WHERE a.admin_id = :adminid: LIMIT 1 ';
                            $sql = $db->bindVars($sql, ':adminid:', $limit, 'integer');
                        }
                        $result = $db->Execute($sql);
                        while (!$result->EOF) {
                            $retVal[] = array('id' => $result->fields['admin_id'],
                                'name' => $result->fields['admin_name'],
                                'email' => $result->fields['admin_email']);
                            $result->MoveNext();
                        }
                        return $retVal;
                    }
                }


                $admin_data = zen_get_users($_SESSION['admin_id']);

                $email = $admin_data[0]['email'];
                $name = $admin_data[0]['name'];
                break;
            case 'mercari':
            case 'xtc':
            case 'gambio':
                $query_sql = "SELECT c.customers_email_address, c.customers_firstname, c.customers_lastname
                                FROM " . TABLE_CUSTOMERS . " c
                                WHERE c.customers_id = '" . mh_db_input($_SESSION['customer_id']) . "'";
                $query = mh_db_query($query_sql);
                if (mh_db_num_rows($query) == 0) {
                    return false;
                }
                $admin_data = mh_db_fetch_array($query);
                $email = $admin_data['customers_email_address'];
                $name = $admin_data['customers_firstname'] . ' ' . $admin_data['customers_lastname'];
                break;
            default:
                echo 'platform not supported';
        }

        return array($email, $name);
    }


    function set_admin_image()
    {
        $this->image = mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_customer_insight/images/user.png';
        return true;
    }

}

?>