<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2016 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

require_once(MH_DIR_CONFIG . 'config_customer_insight.php');

class mh_insight_prospect extends mh_insight_customer
{
    var $email;
    var $admin_language;
    var $language;

    var $id;
    var $is_prospect;
    var $firstname;
    var $birthdate;

    function __construct($recipient_id, $admin_language = '', $language = '')
    {
        parent::__construct();
        $this->is_prospect = true;

        $this->admin_language = ($admin_language == '') ? $_SESSION['languages_id'] : $admin_language;

        // lngrefactor

        $this->language = ($language == '') ? $_SESSION['language'] : $language;

        if ($this->loadProspect($recipient_id)) {

        } else {
            return false;
        }
    }

    function loadProspect($recipient_id)
    {
        $customer_loaded = false;
        $this->id = null;

        $prospect_data = ProspectService::get_prospect_by_id($recipient_id - mh_cfg('MAILBEEZ_NEWSLETTER_SOURCE_PROSPECT_ID_OFFSET', 10000000));

        if ($prospect_data) {
            // common properties
            $this->email = $prospect_data['prospect_email_address'];
            $this->firstname = $prospect_data['prospect_firstname'];
            $this->lastname = $prospect_data['prospect_lastname'];
            $this->id = $recipient_id;
            $this->date_added = $prospect_data['date_added'];
            $this->date_last_modiefied = $prospect_data['last_modified'];
            $this->set_user_image();

            $this->bounces = config_customer_insight::getBounces($this->id);
            $this->hasHardBounce = config_customer_insight::hasHardBounce($this->bounces);

            return true;
        } else {
            return false;
        }
    }
}
