<?php


if (!defined('MH_ROOT_PATH')) {
    // default location
    $_MH_ROOT_PATH = 'mailhive/';
    $_mh_search_paths = array('mailhive/', 'ext/mailhive/', 'includes/external/mailhive/');

    foreach ($_mh_search_paths as $_MH_ROOT_PATH_TRY) {
        if (file_exists(MH_DIR_FS_CATALOG . $_MH_ROOT_PATH_TRY . 'cloudbeez/cloudloader_core.php')) {
            $_MH_ROOT_PATH = $_MH_ROOT_PATH_TRY;
            break;
        }
    }

    define('MH_ROOT_PATH', $_MH_ROOT_PATH);
    if (!defined('MH_DIR_FS_CATALOG')) {
        define('MH_DIR_FS_CATALOG', (substr(DIR_FS_CATALOG, -1) != '/') ? DIR_FS_CATALOG . '/' : DIR_FS_CATALOG);
        define('MH_DIR_WS_CATALOG', (substr(DIR_WS_CATALOG, -1) != '/') ? DIR_WS_CATALOG . '/' : DIR_WS_CATALOG);
    }
}

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/functions/compatibility.php');

if (!mh_cfg('MAILBEEZ_VERSION')) {
    return 0;
}


if (!mh_cfg('MAILBEEZ_CUSTOMER_INSIGHT_LOADED')) {

    $action = mh_get('action',  '');
    if ($action == 'config_update_ok') {
        return false;
    }


    $panel_load_start_time = microtime(true);


    require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'configbeez/config_customer_insight/classes/admin_hooks.php');

    // compatibility

    if (!function_exists('mh_log')) {
        function mh_log($logmsg, $logval)
        {
            return false;
        }
    }
    mh_log("MailBeez CRM Panel loading...", '');

    $mailbeez_admin_hook_in_pages = array('FILENAME_CUSTOMERS', 'FILENAME_ORDERS', 'FILENAME_REVIEWS', 'FILENAME_START');

    // MAILBEEZ_INSIGHT_CUSTOM_PAGES can be defined in e.g. /mailhive/common/local/cfg.php
    /*
     * cfg.php example
     mh_define('MAILBEEZ_CUSTOM_FILENAME_ORDER_REQUESTS', 'order_requests'); // in case there is not constant for filename
     mh_define('MAILBEEZ_INSIGHT_CUSTOM_PAGES', 'MAILBEEZ_CUSTOM_FILENAME_ORDER_REQUESTS');
     */
    if (mh_cfg('MAILBEEZ_INSIGHT_CUSTOM_PAGES')) {
        $mailbeez_admin_hook_in_pages_custom = explode(';', mh_cfg('MAILBEEZ_INSIGHT_CUSTOM_PAGES'));
        $mailbeez_admin_hook_in_pages = array_merge($mailbeez_admin_hook_in_pages, $mailbeez_admin_hook_in_pages_custom);
    }


// exclude panel on these pages
//$mailbeez_admin_hook_in_pages_exclude = array('FILENAME_LOGIN', 'FILENAME_CATEGORIES', 'FILENAME_NEW_ATTRIBUTES', 'stats_', 'salemaker', '&action=');
    $mailbeez_admin_hook_in_pages_exclude_default = array('FILENAME_LOGIN', 'source_prospects_list_edit');
    $mailbeez_admin_hook_in_pages_exclude_custom = explode(';', mh_cfg('MAILBEEZ_INSIGHT_EXCLUDE_PAGES'));

    $mailbeez_admin_hook_in_pages_exclude = array_merge($mailbeez_admin_hook_in_pages_exclude_default, $mailbeez_admin_hook_in_pages_exclude_custom);

    if (mh_cfg('MAILBEEZ_INSIGHT_VIEW_STATUS') == 'True') {
        foreach ($mailbeez_admin_hook_in_pages as $mailbeez_admin_page) {
            if (defined($mailbeez_admin_page)) {
                if (preg_match('/' . mh_fn($mailbeez_admin_page) . '/', $_SERVER['PHP_SELF']) ||
                    preg_match('/' . mh_fn($mailbeez_admin_page) . '/', $_SERVER['REQUEST_URI'])
                ) {
                    $mailbeez_admin_hook = new mailbeez_admin_hooks($mailbeez_admin_page);
                    echo $mailbeez_admin_hook->header_output();
                    continue;
                }
            }
        }
    }

    $show_panel = true;

    mh_log("MailBeez Admin Hooks loaded: %s", microtime(true) - $panel_load_start_time);
    foreach ($mailbeez_admin_hook_in_pages_exclude as $mailbeez_admin_page_exclude) {

        if (is_string($mailbeez_admin_page_exclude) && $mailbeez_admin_page_exclude != '') {
            if (defined($mailbeez_admin_page_exclude)) {
                if (stristr($_SERVER['PHP_SELF'], mh_cfg($mailbeez_admin_page_exclude))) {
                    $show_panel = false;
                }
            } elseif (stristr($_SERVER['REQUEST_URI'], $mailbeez_admin_page_exclude)) {
                $show_panel = false;
            }
        }
//    if (!defined($mailbeez_admin_page_exclude)) {
//        continue;
//    }
    }

    if ($show_panel) {
        $mailbeez_admin_panel = new mailbeez_admin_hooks('PANEL');
        echo $mailbeez_admin_panel->header_output();
    }

    $panel_load_end_time = microtime(true);
    mh_log("MailBeez CRM Panel load time: %s", $panel_load_end_time - $panel_load_start_time);

    mh_define('MAILBEEZ_CUSTOMER_INSIGHT_LOADED', true);

    // session cache garbage collection
    // todo into viewbeez to run async
    mailbeez_cache::gc();
    mailbeez_cache::gc_file();
    mailbeez_cache::gc_file('.php');

}

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'configbeez/config_tour/includes/inc_config_tour.php');

