<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');

class view_conversations extends viewbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'view_conversations';
        $this->module = 'view_conversations';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_CONVERSATIONS_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_CONVERSATIONS_DESCRIPTION');
        $this->sort_order = 50;
        $this->enabled = !mh_saas();
        $this->has_dashboard_view = !mh_cfg('MH_DISABLE_CUSTOMER_INSIGHT_TICKETS');
        $this->set_template();

        $this->menu_cnt = $this->cnt_open($this->customer->id);
    }

    function view_conversations()
    {
        return self::__construct();
    }


    function get_view_content($template)
    {
        $smarty = $this->init_view_content($template);

        return $this->parse_view_content($smarty, $template);
    }

    function get_view_summary()
    {
        $smarty = $this->init_view_summary();

        $smarty->assign('open_msg_cnt', $this->cnt_open($this->customer->id));

        return $this->parse_view_summary($smarty);
    }

    function cnt_open($customers_id = false)
    {
        if (mh_cfg('MH_DISABLE_CUSTOMER_INSIGHT_TICKETS')) {
            return 0;
        }
        return (mh_cfg('MAILBEEZ_INSIGHT_WELCOME_CONVERSATION_HIDE') == 'True') ? 0 : 1;
    }

    function get_view_panel()
    {
        if (mh_cfg('MH_DISABLE_CUSTOMER_INSIGHT_TICKETS')) {
               return '';
           }
        $cnt_open = $this->cnt_open();

        $smarty = $this->init_view_panel('config_beezdesk');

        $hide_example_link = mh_href_link(mh_fn('FILENAME_MAILBEEZ'), 'app=load_app&app_path=config_customer_insight/admin_application_plugins/hide_example_conversation.php');
        $smarty->assign('hide_example_link', $hide_example_link);
        $smarty->assign('hide_example', (mh_cfg('MAILBEEZ_INSIGHT_WELCOME_CONVERSATION_HIDE') == 'True'));

        $content = $this->parse_view_panel($smarty);

        $smarty->assign(array('widget_title' => $this->title,
            'widget_content' => $content,
            'widget_icon_class' => 'icon-envelope',
            'widget_badge_cnt' => $cnt_open,
            'warn' => ($cnt_open > 0) ? true : false,
            'widget_view_module' => 'view_dashboard',
            'widget_dashboard_module' => 'view_conversations'
        ));

        return $this->panel_parse_widget($smarty);

    }


    function get_view_dashboard_widget()
    {

        $smarty = $this->init_view_dashboard_widget();

        return $this->parse_view_dashboard_widget($smarty);

    }


    function get_view_dashboard_content($template)
    {
        $smarty = $this->init_view_dashboard();

        return $this->parse_view_dashboard($smarty);
    }

}


