<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');

class view_dashboard extends viewbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'view_dashboard';
        $this->module = 'view_dashboard';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_DASHBOARD_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_DASHBOARD_DESCRIPTION');

        $this->sort_order = 0;
        $this->enabled = true;
        $this->hidden = true;
        $this->is_dashboard = true;
        $this->has_dashboard_view = true;
        $this->set_template();
    }

    function view_dashboard()
    {
        return self::__construct();
    }    
    
    function get_view_content($template)
    {
        global $mailbeez_insight_all_modules;
        $all_modules_summary = $mailbeez_insight_all_modules;

        $smarty = $this->init_view_content($template);

        $view_widget = array();
        foreach ($all_modules_summary as $sort_order_key => $file) {
            $class = substr($file, 0, strrpos($file, '.'));

            if ($class == $this->code) {
                continue;
            }

            $view_module = $GLOBALS[$class];

            $widget_content = $view_module->get_view_dashboard_widget();

            if ($widget_content == false) {
                continue;
            }

            $view_widget[] = array('title' => $view_module->title,
                'widget_content' => $widget_content,
                'icon_path' => $view_module->get_icon_path(),
                'link' => $view_module->get_menu_link('dashboard')
            );
        }
        $smarty->assign(array('widget_array' => $view_widget));


        return $this->parse_view_content($smarty, $template);
    }

    function get_view_dashboard_content($template) {
        return $this->get_view_content($template);
    }
}
