<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/notificationbeez.php');


class view_notifications extends viewbeez
{

// class constructor
    var $notficationsObj;

    var $notification_id;


    function __construct()
    {
        parent::__construct();
        $this->code = 'view_notifications';
        $this->module = 'view_notifications';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_NOTIFICATIONS_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_NOTIFICATIONS_DESCRIPTION');
        $this->sort_order = 100;
        $this->enabled = true;
        $this->has_dashboard_view = true;

        $this->set_template();
        $this->notficationsObj = new notificationbeez();

        $notification_action = mh_get('notification_action');

        $this->notification_id = mh_get('notification_id');

        if ($notification_action == 'hide' && $this->notification_id > 0) {
            $this->notficationsObj->hide($this->notification_id);
        }
        if ($notification_action == 'unhide' && $this->notification_id > 0) {
            $this->notficationsObj->unhide($this->notification_id);
        }


        if (mh_cfg('MAILBEEZ_CUSTOMER_INSIGHT_NOT_INSTALLED')) {
            $this->set_view_module_directory(MH_ROOT_PATH . 'configbeez/config_customer_insight/viewbeez/' . $this->view_module_directory_path);
            $smarty = $this->init_view_content($this->view_module_directory_path, null);

            $title = $this->parse_view_content($smarty, 'msg_install_title.tpl.html');
            $summary = $this->parse_view_content($smarty, 'msg_install_summary.tpl.html');
            $text = $this->parse_view_content($smarty, 'msg_install.tpl.html');

            //$this->language

            $notification = array('title' => $title,
                'notification_summary' => $summary,
                'notification' => $text,
                'module' => 'install',
                'ref_id' => 1,
                'iteration' => date("YW"),
                'customers_id' => null,
                'severity' => 5,
                'link' => '##shownotification##',
                'link_type' => 'P', // E - external, I - internal, P - popup
                'panel_click_action' => 'H', // H - hide
                'channel_id' => 0,
                'status' => '0',
                'icon_style' => 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_shopvoting/viewbeez/view_shopvoting/icon_panel.png); background-color: #c4e1fd'
            );

            $this->notficationsObj->add($notification);

        }

        if ($this->cnt_notifications($this->customer->id) > 0) {
            $this->sort_order = 5;
        }

        $this->menu_cnt = $this->cnt_notifications($this->customer->id);

        $this->dashboard_viewpage = mh_get('dashboard_viewpage', 'open');
        $this->panel_ajax_refresh = true;
    }

    function view_notifications()
    {
        return self::__construct();
    }

    function get_view_content($template)
    {
        $smarty = $this->init_view_content($template);

        return $this->parse_view_content($smarty, $template);
    }

    function get_view_summary()
    {
        $smarty = $this->init_view_summary();

        return $this->parse_view_summary($smarty);
    }

    function cnt_notifications($customers_id = null)
    {
        if ($customers_id == null) {
            $this->set_cache_id('global', 'num_of_notifications');
        } else {
            $this->set_cache_id($customers_id, 'num_of_notifications');
        }

        if ($cache = $this->read_cache()) {
            return $cache['value'];
        }

        $cnt = $this->notficationsObj->getNotificationCount(null, null, $customers_id);

        return $this->set_cache($cnt, 'app');

    }


    function get_view_panel()
    {
        $smarty = $this->init_view_panel($this->module);

        $notifications_limit = 3;
        $cnt_open = $this->cnt_notifications();

        $notficationsArray = $this->notficationsObj->getOpenNotificationList($notifications_limit);

        $notficationsArray = $this->set_single_view_link($notficationsArray);

        $smarty->assign('notifications', $notficationsArray);
        $smarty->assign('more_open', $cnt_open - $notifications_limit);

        $content = $this->parse_view_panel($smarty);

        $smarty->assign(array('widget_title' => $this->title,
            'widget_content' => $content,
            'widget_icon_class' => 'icon-flag',
            'widget_badge_cnt' => $cnt_open,
            'warn' => ($cnt_open > 0) ? true : false,
            'widget_view_module' => 'view_dashboard',
            'widget_dashboard_module' => 'view_notifications'
        ));

        return $this->panel_parse_widget($smarty);
    }

    function get_view_dashboard_widget()
    {
        $smarty = $this->init_view_dashboard_widget();

        $notficationsArray = $this->notficationsObj->getOpenNotificationList(1);
        $notficationsArray = $this->set_single_view_link($notficationsArray);

        $smarty->assign('notifications', $notficationsArray);
        $smarty->assign('open_ntf_cnt', $this->cnt_notifications($this->customer->id));

        return $this->parse_view_dashboard_widget($smarty);
    }

    function get_view_dashboard_content($template)
    {
        $smarty = $this->init_view_dashboard();
        switch ($this->dashboard_viewpage) {
            case 'dismissed':
                $notficationsArray = $this->notficationsObj->getDismissedNotificationList();
                break;
            case 'single':
                $notficationsArray = $this->notficationsObj->getNotification($this->notification_id);
                $smarty->assign('single_view', true);
                break;
            default:
                $notficationsArray = $this->notficationsObj->getOpenNotificationList();
                break;
        }

        $notficationsArray = $this->set_single_view_link($notficationsArray);

        $smarty->assign('notifications', $notficationsArray);
        $smarty->assign(array('dashboard_viewpage' => $this->dashboard_viewpage));
        return $this->parse_view_dashboard($smarty);
    }

    function set_single_view_link($notficationsArray)
    {

        if (!is_array($notficationsArray)) {
            return $notficationsArray;
        }

        $notficationsArrayNew = array();

        foreach ($notficationsArray as $key => $item) {
            $notficationsArrayNew[$key] = $item;
            if ($item['link'] == '##shownotification##') {
                $notficationsArrayNew[$key]['notification_only'] = true;
            }
            $notficationsArrayNew[$key]['link'] = str_replace('##shownotification##', $this->get_menu_link('dashboard_static') . '&dashboard_viewpage=single&notification_id=' . $item['id'], $item['link']);
        }

        return $notficationsArrayNew;
    }

    public function data_update($customers_id = null)
    {
        // update notification count
        $this->set_cache_id('global', 'num_of_notifications');
        $this->purge_cache('app');
        $this->cnt_notifications();
    }
}