<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');
require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/context_order.php');

class view_orders extends viewbeez
{

// class constructor
    var $order_statuses;

    function __construct($order_id = null)
    {
        parent::__construct();

        $this->code = 'view_orders';
        $this->module = 'view_orders';
        $this->version = '3.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_ORDERS_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_ORDERS_DESCRIPTION');
        $this->icon = 'icon_48.png';

        $this->sort_order = 20;
        $this->enabled = true;
        $this->set_template();
        $this->order_statuses = mh_insight_order::getOrderStatuses();

        $this->menu_cnt_default = $this->cnt_orders();


    }

    function get_view_content($template)
    {
        $smarty = $this->init_view_content($template);


        // implement logic to get data
        // assign to smarty template variables

        // $smarty->assign(array('products' => $products_data_array));
        // $smarty->assign('name' => $name);

        // todo

        $orders_result = $this->read_orders($this->customer->id, $this->customer->email);

        $smarty->assign('orders', $orders_result);

        $smarty->assign('get_order_url', mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_customer_insight/admin_application_plugins/datagrid.php&app_action=get_order&customers_id=' . $this->customer->id));

        $smarty->assign('MAILBEEZ_ORDER_DG_PAGE_SIZE', 900);

        return $this->parse_view_content($smarty, $template);
    }

    function get_view_summary($smarty = null)
    {
        $data_only = true;
        if (!$smarty) {
            $smarty = $this->init_view_summary();
            $data_only = false;
        }

        $order = new mh_insight_order(mh_insight_order::getLastOrderID($this->customer->id));
        if ($order->info) {
            $order->info['date_purchased'] = mh_datetime_short($order->info['date_purchased']);
            if (isset($order->info['info.last_modified'])) {
                $order->info['info.last_modified'] = mh_datetime_short($order->info['info.last_modified']);
            }
        }

        $turnover = mh_insight_order::getOrdersTurnover($this->customer->id);
        $num_of_orders = $this->get_number_of_orders($this->customer->id);


        $first_last_order_array = $this->get_first_last_order_data($this->customer->id);


        $smarty->assign('turnover', mh_price($turnover));
        $smarty->assign('number_of_orders', $num_of_orders);
        $smarty->assign('avg_order_value', ($num_of_orders > 0) ? mh_price($turnover / $num_of_orders) : mh_price(0));
        $smarty->assign('first_order_date', (is_array($first_last_order_array)) ? $first_last_order_array['first_order']['date_purchased_short'] : '-');
        $smarty->assign('first_order_timestamp', (is_array($first_last_order_array)) ? $first_last_order_array['first_order']['date_purchased'] : '-');
        $smarty->assign('first_order_value', (is_array($first_last_order_array)) ? mh_price($first_last_order_array['first_order']['order_total_value']) : mh_price(0));
        $smarty->assign('last_order_date', (is_array($first_last_order_array)) ? $first_last_order_array['last_order']['date_purchased_short'] : '-');
        $smarty->assign('last_order_timestamp', (is_array($first_last_order_array)) ? $first_last_order_array['last_order']['date_purchased'] : '-');
        $smarty->assign('last_order_value', (is_array($first_last_order_array)) ? mh_price($first_last_order_array['last_order']['order_total_value']) : mh_price(0));
        $smarty->assign('order', $order);
        $smarty->assign('order_statuses', $this->order_statuses);

        if ($data_only) {
            return $smarty;
        } else {
            return $this->parse_view_summary($smarty);
        }

    }

    function get_view_la_widget()
    {
        $smarty = $this->init_view_la_widget();


        $smarty = $this->get_view_summary($smarty);

        $limit = 3;
        $orders_result = $this->read_orders($this->customer->id, $this->customer->email, $limit);
        $smarty->assign('orders', $orders_result);

        $smarty->assign('more_orders', $this->cnt_orders() - $limit);

        return $this->parse_view_la_widget($smarty);
    }

    function read_orders($customer_id, $customers_email_address, $limit = 100)
    {

        if ((int)$customer_id == 0) {
            return array();
        }

        $this->set_cache_id('orders', $customer_id);

        if ($cache = $this->read_cache()) {
            $return = $cache['value'];
            return (is_array($return)) ? array_slice($return, 0, $limit) : $return;
        }

        $orders_data_array_raw = mh_insight_order::get_order_list($customer_id, '', $customers_email_address);
        $orders_data_array = mh_arr_val($orders_data_array_raw, 'rows');

        if (mh_cfg('MAILBEEZ_CONFIG_PROFILING_ENGINE_STATUS') == 'True' && file_exists(MH_DIR_CONFIG . 'config_profiling_engine/classes/mh_profiling.php')) {

            require_once(MH_DIR_CONFIG . 'config_profiling_engine/classes/mh_profiling.php');

            if (is_array($orders_data_array) && sizeof($orders_data_array) > 0) {

                foreach ($orders_data_array as $idx => $order) {
                    $order['orders_profiling'] = mh_profiling::get_profile_tags_by_order_id($order['orders_id']);
                    $orders_data_array[$idx] = $order;
                }
            }
        }

        $return = $this->set_cache($orders_data_array);

        return (is_array($return)) ? array_slice($return, 0, $limit) : $return;
    }


    function get_number_of_orders($customer_id)
    {

        $order_array = $this->read_orders($customer_id, $this->customer->email);

        if (is_array($order_array)) {
            return count($order_array);
        }
        return 0;

        /*
        $this->set_cache_id('num_of_orders', $customer_id);

        if ($cache = $this->read_cache()) {
            return $cache['value'];
        }

        return $this->set_cache(mh_insight_order::getNumberOfOrders($customer_id));
        */
    }

    function get_first_last_order_data($customer_id)
    {
        $order_array = $this->read_orders($customer_id, $this->customer->email);

        if (is_array($order_array) && sizeof($order_array) > 1) {
            $last_order = array_shift($order_array);
            $first_order = array_pop($order_array);
            return array('first_order' => $first_order, 'last_order' => $last_order);
        } elseif (is_array($order_array) && sizeof($order_array) == 1) {
            $last_order = array_shift($order_array);
            return array('first_order' => $last_order, 'last_order' => $last_order);
        }

        return false;
    }


    function cnt_orders()
    {
        return $this->get_number_of_orders($this->customer->id);
    }

}

