<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');

class view_overview extends viewbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'view_overview';
        $this->module = 'view_overview';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_OVERVIEW_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_OVERVIEW_DESCRIPTION');

        $this->sort_order = 1;
        $this->enabled = true;
        $this->is_prospect_enabled = true;
        $this->set_template();
    }

    function view_overview()
    {
        return self::__construct();
    }

    function get_view_content($template)
    {
        global $mailbeez_insight_all_modules;
        $all_modules_summary = $mailbeez_insight_all_modules;

        $smarty = $this->init_view_content($template);

        $view_summary = array();
        foreach ($all_modules_summary as $sort_order_key => $file ) {
            $class = substr($file, 0, strrpos($file, '.'));

            if ($class == $this->code) {
                continue;
            }

            $view_module = $GLOBALS[$class];

            if (!$view_module->enabled) {
                continue;
            }

            $overview_content = $view_module->get_view_summary();

            if ($overview_content == false) {
                continue;
            }

            $view_summary[] = array('title' => $view_module->title,
                'summary' => $overview_content,
                'icon_path' => $view_module->get_icon_path(),
                'link' => $view_module->get_menu_link()
            );
        }
        $smarty->assign(array('summary_array' => $view_summary));

        // implement logic to get data
        // assign to smarty template variables

        // $smarty->assign(array('products' => $products_data_array));
        // $smarty->assign('name' => $name);

        return $this->parse_view_content($smarty, $template);
    }


}

?>