<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_CONFIG . 'config_customer_insight/classes/viewbeez.php');

class view_version_check extends viewbeez
{

// class constructor
    function __construct($order_id = null)
    {
        parent::__construct();

        $this->code = 'view_version_check';
        $this->module = 'view_version_check';
        $this->version = '1.0';
        $this->title = mh_lng('MAILBEEZ_VIEW_VERSION_CHECK_TITLE');
        $this->description = mh_lng('MAILBEEZ_VIEW_VERSION_CHECK_DESCRIPTION');
        $this->hidden = true;
        $this->has_dashboard_view = false;

        $this->sort_order = 999;
        $this->enabled = !mh_cfg('MH_DISABLE_CORE_VERSION_CHECK') && !mh_cfg('is_cloud');

        $this->set_template();
//        $this->menu_cnt_default = $this->cnt_version_check();
    }

    public function data_update()
    {

        // timed caching
        if (isset($_SESSION['mh_version_core_check_notification']) && (time() - $_SESSION['mh_version_core_check_notification_timestamp'] < 3600)) {
            return $_SESSION['mh_version_core_check_notification'];
        }

        $this->notficationsObj = new notificationbeez();

        // sets  $_SESSION['mh_version_core_check']
        mh_version_check_core();

        if (isset($_SESSION['mh_version_core_check']) && $_SESSION['mh_version_core_check']) {
            mh_log("version_check_update: " . $this->code . " ", $_SESSION['mh_version_core_check']);

            $version = $_SESSION['mh_version_core_check'];

            // newer version notification - remove old notifications
            if (isset($_SESSION['mh_version_core_check_notification_version']) && $_SESSION['mh_version_core_check_notification_version'] <= $version) {
                $this->notficationsObj->deleteNotification($this->code);
            } elseif (!isset($_SESSION['mh_version_core_check_notification_version'])) {
                $this->notficationsObj->deleteNotification($this->code);
            }

            $_SESSION['mh_version_core_check_notification_version'] = $version;

            // once a day
            $uid = date("Yz");
            // once a week
            $uid = date("YW");

            $notification = array('title' => mh_cfg('MAILBEEZ_VIEW_VERSION_CHECK_NOTIFICATION_TITLE'),
                'notification_summary' => sprintf(MAILBEEZ_VIEW_VERSION_CHECK_NOTIFICATION_SUMMARY, $version),
                'notification' => sprintf(MAILBEEZ_VIEW_VERSION_CHECK_NOTIFICATION, $version),
                'module' => $this->code,
                'ref_id' => $uid . str_replace('.', '', $version),
                'iteration' => 1,
                'customers_id' => null,
                'severity' => 1,
                'link' => mh_href_link(FILENAME_MAILBEEZ, 'cloudloader_mode=update_core'),
                'link_type' => 'P', // E - external, I - internal, P - popup
                'panel_click_action' => 'H', // H - hide
                'channel_id' => 0,
                'status' => '0',
                'icon_style' => 'background-image: url(' . mh_cfg('MH_CATALOG_SERVER') . mh_cfg('MH_DIR_WS_CATALOG') . mh_cfg('MH_ROOT_PATH') . 'configbeez/config_customer_insight/viewbeez/view_version_check/icon_panel.png); background-color: #c4e1fd');

            $this->notficationsObj->add($notification);
        }
        $_SESSION['mh_version_core_check_notification'] = true;
        $_SESSION['mh_version_core_check_notification_timestamp'] = time();
        echo "update version_check";
    }

}
