<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
 */

///////////////////////////////////////////////////////////////////////////////
///																			 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_dq_check extends configbeez
{
// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_dq_check';
        $this->module = 'config_dq_check'; // same as folder name
        $this->version = '2.0'; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_DQ_CHECK_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_DQ_CHECK_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_ma_64.png';
        $this->icon = '../../common/images/icon_ma.png';
        $this->removable = false; // can't be removed
        $this->stealth = true; // don't list as an installed module
        $this->display_as_submodule_of = 'config';
        $this->sort_order = 4;
        $this->enabled = mh_cfg('MAILBEEZ_MAILHIVE_STATUS') == 'True';
        $this->on_cfg_save_clear_template_c = true;

        if (mh_cfg('MAILBEEZ_DQ_CHECK_STATUS') == 'False') {
            $this->admin_action_plugins = 'confirm.php';
            $this->admin_action_plugins_path = MH_DIR_CONFIG;
        }


        $this->documentation_key = 'config_dq_check'; // leave empty if no documentation available
        $this->documentation_root = 'https://www.mailbeez.com/documentation/installation/config/';

        $this->hidden = true;
    }

    function config_dq_check()
    {
        self::__construct();
    }

// class methods

    function getAudience()
    {
        return false;
    }

    function check()
    {
        return true;
    }

    function remove()
    {
        return false;
    }

    // installation methods

    function keys()
    {
        if (mh_cfg('MAILBEEZ_DQ_CHECK_STATUS') == 'True') {
            $keys_array = array('MAILBEEZ_DQ_CHECK_STATUS', 'MAILBEEZ_DQ_CHECK_OPEN_RATES_AUTO', 'MAILBEEZ_DQ_CHECK_DO_RUN', 'MAILBEEZ_DQ_CHECK_AUTOINSERT_PIX', 'MAILBEEZ_DQ_CHECK_REWRITE_FORMAT', 'MAILBEEZ_DQ_CHECK_SPLITPAGE_NUM', 'MAILBEEZ_DQ_CHECK_BEGIN_OF_TIME');
        }
        return $keys_array;
    }

    function install()
    {
        return false;
    }

}

?>
