<?php
/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2014 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/newsletter2go_v2.class.php');

$nl2g_status = false;
$nl2g_reg_status = false;
$nl2g_error = false;
$nl2g_error_msg = '';
$ping = false;
$senderIdList = '';
if (mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_V2_AUTH_KEY') && ('Newsletter2Go' == mh_cfg('MAILBEEZ_CONFIG_EMAIL_ENGINE'))) {
    $nl2g_status = true;
    try {
        $nl2go = NL2GO\Api::getInstance();
        $ping = $nl2go->ping();
    } catch (Exception $e) {
        print_r($e->getMessage());
    }

    if (isset($nl2go) && $ping) {

        $status = $nl2go->getStatus();

        $senderIds = $nl2go->getSenderids();

        $integrationData = $nl2go->getIntegrationData();
        $addSPFDomains = array();

        if (sizeof($senderIds) > 0) {
            $senderIdList .= '<div>';
            $senderIdList .= '<div class="mb_action_box headline" style="text-align: center">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_DOMAINS') . '</div><hr>';
            foreach ($senderIds as $senderId) {
                $fcolor = ($senderId['is_verified']) ? 'color_success' : '';

                $senderIdList .= '<span style="font-weight: bold; " class=" ' . $fcolor . '">' . $senderId['domain'] . '</span>';
                $senderIdList .= ($senderId['is_verified']) ? ' <i class="fa fa-check color_success"></i>' : ' <div class="badge_warning">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_BADGE') . '</div>';
                $senderIdList .= '<br>';
//                $senderIdList .= ($senderId['is_verified']) ? 'OK' : 'NOT OK';
//                $senderIdList .= ($senderId['is_verified']) ? '' : $senderId['sender_id'];
                if (!$senderId['is_verified']) {
                    $addSPFDomains[$senderId['domain']] = $senderId['sender_id'];
                }
            }
            $senderIdList .= '</div>';


            if (sizeof($addSPFDomains) > 0) {
                $senderIdList .= '<div>';
                foreach ($addSPFDomains as $addSPFDomain => $addSPFDomainEntry) {
                    $senderIdList .= '<hr>' . sprintf(MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT, $addSPFDomain, $addSPFDomainEntry) . '<br><a href="#" onclick="document.location.reload(); return false;">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS_CHECK') . '</a><br>';
                }
                $senderIdList .= '</div>';
            }
        } else {
            $domain = str_replace('www.', '', $_SERVER['SERVER_NAME']);
            $addsenderurl = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_email_engine_n2g/admin_application_plugins/addsender.php&domain=' . urlencode($domain));

            $senderIdList = '<div style="color: red; text-align: center; font-weight: bold">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NO_DOMAIN') . '</div>';
            $senderIdList .= '<hr><b>' . sprintf(MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_NO_DOMAIN_ADD, $addsenderurl, $domain) . '</b>';
        }


        $credits = $nl2go->getCredits();

        if (('verified' == $status)) {
            $nl2g_reg_status = true;

        } else {
            $nl2g_error = true;
            $nl2g_error_msg = $credits['reason'];
        }
    } else {
        $nl2g_error = true;
        $nl2g_error_msg = "invalid credentials";
    }


}

$nl2g_unlink = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=config_email_engine/admin_application_plugins/unlink.php');

$register_url = NL2GO\Api::buildEntrypoint();

$msg = '';

if ($nl2g_error) {
    // $nl2g_error_msg
    $contents[] = array('text' => '<div class="mb_action_box">
            <div class="mb_action_box headline">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ERROR_HEADLINE') . '</div>
            <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ERROR_TEXT') . '</div>
            <div class="mb_action_box text"><div align="center" style="font-weight: bold; color: #f00; padding-top: 10px; ">' . $nl2g_error_msg . '</div></div>
            
            <div style="text-align: center; padding: 20px; "><a href="' . $nl2g_unlink . '" id="n2go_unlink" style="font-weight: bold; font-size: 150%; color: #f00;text-decoration: underline">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK') . '</a></div>
            </div>
            ');

}

elseif ($nl2g_status) {

    $output = '<div class="mb_action_box" style="background-color: #fff">
    <div class="mb_action_box text" style="text-align: center">' . '<img src="' . $config_module_directory_ws . 'config_email_engine_n2g/images/logo.png" width="300" height="52" vspace="20" hspace="5" style="margin: 30px 30px;">';

    $output .=
        (($nl2g_reg_status) ?
            '<div class="mb_action_box text">
                                <div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid green; padding: 10px;">' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS_OK . '

                                </div></div>
                        </div>' :
            '<div class="mb_action_box text">
                    <div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid red; padding: 10px;">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS') . '<br><br>
                    <a href="#" onclick="document.location.reload(); return false;">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REG_STATUS_CHECK') . '</a>

                    </div></div>
            </div>');
    $output .= ' ' . '</div>
        <div class="mb_action_box headline"><div align="center">' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CREDITS . ':<br>' . (int)$credits['credits_total'] . '</div></div>

        <div align="center" style="width:95%; margin: auto; position: relative; margin-top: 15px; margin-bottom: 15px;">' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; width: 33%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['credits_freemail'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_FREEMAILCOUNT . '</div>' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; border-left: 0px; width: 32%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['credits_email'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_EMAILCOUNT . '</div>' .
        '<div class="mb_action_box text" style="float:left; border: 1px solid #c0c0c0; border-left: 0px; width: 33%; height: 80px; text-align: center">' .
        '<div style="font-size: 20px;padding-top: 10px;padding-bottom: 7px">' . $credits['credits_abo'] . '</div>' .
        MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_ABOCOUNT .
        '</div>
        <br clear="both">
        </div>
        <div class="mb_action_box text">
        <div align="center"><a href="' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_V2_LOAD_URL . '" target="_blank" style="font-weight: bold">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CREDITS_BUY_BUTTON') . '</a></div>
        <br>
        <div class="mb_action_box text"><div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid #c0c0c0; padding: 10px;">' . $senderIdList . '
        </div></div></div>';


    $output .= '<div class="mb_action_box text"><div align="center" style="width:95%; margin: auto; position: relative; margin-top: 0px; margin-bottom: 15px;"><div style="border: 1px solid #c0c0c0; padding: 10px;">';

    $output .= (is_object($integrationData)) ? '
        <img src="' . $integrationData->img_url . '" width="30" align="absmiddle"><br>
        ' . $integrationData->name . ' v' . $integrationData->version . '<br>
        Entrypoint: ' . $integrationData->auth->entrypoint . '<br>
        Created at: ' . $integrationData->created_at . '<br>' .
//        'Setup completed: ' . $integrationData->is_setup_completed . '<br>' .
        'Connection success: ' . $integrationData->connection_success . '<br>
        Counter Connection failed: ' . $integrationData->counter_connection_failed . '<br>
        
        ' : ' Error retrieving Integration Data ';
    $output .= '</div></div></div>';

    if ($nl2g_reg_status) {

        $output .= '<script type="text/javascript">
                        jQuery(document).ready(function () {
                            $(\'#n2go_unlink\').click(function (e) {
                                e.preventDefault(); // Prevent the href from redirecting directly
                                var linkURL = $(this).attr("href");
                                warnBeforeUnlink(linkURL);
                            });
                    
                            function warnBeforeUnlink(linkURL) {
                                swal({
                                    title: "' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK_CONFIRM_TITLE . '",
                                    text: "' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK_CONFIRM_TEXT . '",
                                    icon: "warning",
                                    dangerMode: true,
                                    buttons: {
                                        cancel: "' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK_CONFIRMN_CANCEL_BUTTON . '",
                                        confirm: { 
                                            text: "' . MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK_CONFIRM_OK_BUTTON . '",
                                            value: "unlink"
                                        }
                                    }
                                }).then(function (value) {
                                    switch (value) {
                                        case "unlink":
                                            window.location.href = linkURL;
                                            break;
                                    }
                                });
                            }
                        });
                        </script>';
        $output .= '<div style="text-align: center"><a href="' . $nl2g_unlink . '" id="n2go_unlink">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_UNLINK') . '</a></div>';
    }
    $output .= '</div>';
    $contents[] = array('text' => $output);
} else {
    $contents[] = array('text' => '<div class="mb_action_box" style="background-color: #fff">
        <div class="mb_action_box text">' . '<img src="' . $config_module_directory_ws . 'config_email_engine_n2g/images/logo.png" width="300" height="52"  vspace="20" hspace="5" style="margin: 30px 30px;">' . '</div>

        <div style="padding: 15px; padding-top: 5px">
        <div class="mb_action_box"><h2>' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_HEADLINE') . '</h2></div>
        <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_TEXT') . '<br><br></div>
        <div class="mb_action_box buttons" style="clear: both"><div align="center"><a href="' . $register_url . '" class="context_view_button" target="_blank">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_V2_REGISTER_BUTTON') . '</a><br><br></div></div>
        <div class="mb_action_box text">' . mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_INFO_TEXT') . '<br><br></div>
        <div class="mb_action_box text"><div align="center">' . $msg . '</div></div></div>
        </div>');
//}

}
