/*
 Must return javascript code

 PHP code will be parsed

 <?php
 echo time();
 ?>
 */
// Define the tour!
var tour = {
    nextOnTargetClick: true,


    steps: [

        {
            title: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_STEP1; ?>",
            content: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_CONTENT_TOUR_STEP1; ?>",
            target: document.querySelector('[id*="tab_configbeez"]'),
            placement: "bottom",
            multipage: true, // indicates that the next step is on a different page.
            showNextButton: true,

            onNext: function () {
                window.location = "<?php echo mh_href_link(FILENAME_MAILBEEZ, 'tab=configbeez&module=config_email_engine'); ?>"
            }
        },
        {
            title: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_STEP2; ?>",
            content: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_CONTENT_TOUR_STEP2; ?>",
            target: document.querySelector('[id*="config_email_engine"]'),
            placement: "right",
            xOffset: "center",
            yOffset: -20,

            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,
        },
        {
            title: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_STEP3; ?>",
            content: "<?php echo MH_TOUR_MAILBEEZ_EMAIL_CONTENT_TOUR_STEP3; ?>",
            target: "MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT",
            placement: "left",
            yOffset: -10,
            multipage: false, // indicates that the next step is on a different page.
            showNextButton: true,
            width: 500,

            ctaLabel: '<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_EMAIL_CTA_BUTTON; ?>',

            showCTAButton: true,

            onCTA: function () {
                window.location = 'mailto:?subject=<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_EMAIL_BODY_SUBJECT; ?>&body=<?php echo MH_TOUR_MAILBEEZ_EMAIL_TITLE_TOUR_EMAIL_BODY_INTRO; ?>%0A%0A%0A'+ jQuery(document.querySelector('[id="MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT"]').innerHTML.replace(/<br>/gi,'%0A')).text() + '%0A<?php echo MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_SPF_HINT_LINK; ?>';
                return false
            }
        }


    ]
}

