<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010, 2011, 2012 MailBeez

  Licensing Terms & Other Conditions of this
  Mailbeez Module:

  Unless you have our prior written consent, you must NOT directly or indirectly license,
  sub-license, sell, resell, or provide for free or make an offer to do any of these things.
  All of these things are strictly prohibited with this MailBeez Pro Module.

  One Purchase for one Shop - please contact cord@mailbeez.com for volume discounts and
  reseller agreements.

  OpenSource but not free - please respect this license agreement.

 */

mh_define('MH_BYPASS_TEMPLATE', TRUE);

mh_define('MH_POPUP', true);

include_once(MH_DIR_CONFIG . 'config_email_engine_n2g.php');
require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/newsletter2go_register.class.php');

$app_module_id = 'config_email_engine_n2g';
$app_path_module = 'configbeez/' . $app_module_id;
$app_url = mh_href_link(FILENAME_MAILBEEZ, 'app=load_app&app_path=' . $app_path_module . '/admin_application_plugins/register.php&' . mh_get_all_get_params(array('app', 'app_path', 'app_action', 'x', 'y')));

mh_load_modules_language_files(MH_DIR_CONFIG, $app_module_id);
$success = (isset($_GET['success'])) ? true : false;
$error = false; // (isset($_GET['success'])) ? true : false;

$app_action = mh_get('app_action', '');
if (mh_not_null($app_action)) {
    switch ($app_action) {
        case 'submit':
            /** create a new Newsletter2Go user **/

//            print_r($_POST);
//            mh_exit();

            /*
            $params = array(

                "user_mail" => "n2g1@mailbeez.com",
                "user_firstname" => "Harald",
                "user_lastname" => "Meier",
                "user_phone" => "0049 39 12345678",
                "user_company" => "Very Incorporated Inc.",
                "user_address" => "Hauptstr. 1",
                "user_postcode" => "12345",
                "user_city" => "Berlin",
                "user_country" => "de",
                "shop_url" => "http://www.example.org"

            );
            */
            $error_msg_array = array();

            if (!$_POST['user_mail']) {
                $error = true;
                $error_msg_array[] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_EMAIL;
            }

            if (!$_POST['user_firstname']) {
                $error = true;
                $error_msg_array[] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_FIRSTNAME;
            }

            if (!$_POST['user_lastname']) {
                $error = true;
                $error_msg_array[] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_LASTNAME;
            }
            if (!$_POST['shop_url']) {
                $error = true;
                $error_msg_array[] = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_URL;
            }

            $user_firstname = $_POST['user_firstname'];
            $user_lastname = $_POST['user_lastname'];
            $user_mail = $_POST['user_mail'];
            $shop_url = $_POST['shop_url'];

            if ($error) {
                $error = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_MISSING;
                $error_msg = implode('<br>', $error_msg_array);
            } else {
                //create new Newsletter2Go-Object
                $nl2go_reg = new newsletter2go_register(MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_API_LANG);
                $result = $nl2go_reg->createUser($_POST);
                //var_dump($result);

                switch ($result['status']) {

                    case 200:
                        $n2g_api_key = $result['value'];
                        mh_insert_config_value(array(
                            'configuration_key' => 'MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_API_KEY',
                            'configuration_value' => $n2g_api_key
                        ), true);
                        mh_insert_config_value(array(
                            'configuration_key' => 'MAILBEEZ_CONFIG_EMAIL_ENGINE',
                            'configuration_value' => 'Newsletter2Go'
                        ), true);

                        // set integration

                        require_once(MH_DIR_CONFIG . 'config_email_engine_n2g/classes/newsletter2go.class.php');
                        $nl2go = new Newsletter2Go($n2g_api_key);
                        $result = $nl2go->createIntegration();

                        mh_redirect(mh_href_link(FILENAME_MAILBEEZ, mh_get_all_get_params(array('app_action')) . '&success=true'));
                        break;
                    case 429:
                        // 'at least one email address is not valid'

                        $error = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_EMAIL_INVALID;
                        $error_msg = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_EMAIL_INVALID_INFO;

                        break;


                    case 448:
                        // 'User already exists'

                        $error = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_EMAIL_TAKEN;
                        $error_msg = MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_CHECK_EMAIL_TAKEN_INFO;
                        break;

                }
            }


            break;
    }
}

$shop_url = $_SERVER['HTTP_HOST'];


?>


<?php echo mh_draw_form('n2g_register', FILENAME_MAILBEEZ, 'app=load_app&app_path=' . $app_path_module . '/admin_application_plugins/register.php&' . mh_get_all_get_params(array('app', 'app_path', 'app_action', 'x', 'y')) . '&app_action=submit'); ?>
<?php
//echo mh_draw_hidden_field('app', 'load_app');
//echo mh_draw_hidden_field('app_path', $app_path_module . '/admin_application_plugins/register.php');
//echo mh_draw_hidden_field('app_action', 'submit');
?>

<style>
    body {
        background-image: url('<?php echo $config_module_directory_ws; ?>config_email_engine_n2g/images/teaser3.jpg');
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-position: top center;

    }

    input#submit {

        background: none repeat scroll 0 0 #46c152 !important;
        border: 1px solid transparent;
        border-radius: 2px;
        color: #ffffff;
        display: inline-block;
        font-size: 16px;
        font-weight: 300;
        margin-top: 10px;
        padding: 12px 24px;
        transition: all 100ms ease-in 0s;
        font-family: 'Open Sans', 'Helvetica Neue', Helvetica, Arial, sans-serif
    }

    input#submit:hover {
        background-color: transparent !important;
        border: 1px solid #46c152 !important;
        color: #46c152 !important;
        cursor: pointer;
        transition: all 100ms ease-in 0s;
    }
</style>

<div class="topinfo" style="margin: 30px; margin-top: 15px">


    <?php if ($success) { ?>

        <script type="text/javascript">
            window.setTimeout("mbCloseBox()", 25000);

            function mbCloseBox() {
                parent.$.fn.ceebox.closebox();
                parent.document.location.href="<?php echo mh_href_link(FILENAME_MAILBEEZ, 'tab=configbeez&module=config_email_engine') ?>";
            }
        </script>

        <table border="0" cellspacing="0" cellpadding="3" width="50%">

            <tr valign="bottom">
                <td class="main" width="75%">
                    <div style="
                 color: #46c152;
                 font-size: 22px;
                 line-height: 28px; font-family: 'Open Sans','Helvetica Neue',Helvetica,Arial,sans-serif"
                        >
                        <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_SUCCESS_TITLE'); ?>
                        <div style="font-size: 65%; font-weight: normal; line-height: normal; margin-bottom: 7px">
                            <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_SUCCESS_TEXT'); ?>

                        </div>
                    </div>
                    <div style="color: #909090">
                        <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_SUCCESS_NOTE'); ?>
                    </div>

                    <br>
                    <br>

                    <div style="padding-bottom: 17px; float: left">
                        <input id="submit" type="submit" value="<?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_BUTTON_CLOSE'); ?>" onclick="mbCloseBox(); return false;">
                    </div>

                    <div style="float: left; margin-top: 20px; margin-left: 20px">
                        <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_CONTACT'); ?>
                    </div>

                    <br clear="both">

                </td>
            </tr>
        </table>

    <?php } else { ?>
        <table border="0" cellspacing="0" cellpadding="3" width="55%">

            <tr valign="bottom">
                <td class="main" width="75%">
                    <?php if ($error) { ?>
                        <div style="color: #f96f00;
                                      font-size: 22px;
                                      line-height: 28px; font-family: 'Open Sans','Helvetica Neue',Helvetica,Arial,sans-serif"
                            >
                            <?php echo $error; ?>
                            <div style="font-size: 65%; font-weight: normal; line-height: normal; margin-bottom: 7px">
                                <?php echo $error_msg; ?>
                            </div>
                        </div>
                    <?php } else { ?>
                        <div style="
                    color: #1cbaff;
                    font-size: 22px;
                    line-height: 28px; font-family: 'Open Sans','Helvetica Neue',Helvetica,Arial,sans-serif"
                            >
                            <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_TITLE'); ?>
                            <div style="font-size: 65%; font-weight: normal; line-height: normal; margin-bottom: 7px">
                                <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_SUB_TITLE'); ?>
                            </div>
                        </div>
                        <div style="color: #909090">
                            <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_TEXT'); ?>
                        </div>
                        <div style="padding-bottom: 17px"></div>

                        <div style="color: #1cbaff;
                    font-size: 22px;
                    line-height: 20px; font-family: 'Open Sans','Helvetica Neue',Helvetica,Arial,sans-serif"
                            ><?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_CALL2A'); ?>
                        </div>
                    <?php } ?>

                </td>
            </tr>


            <tr valign="bottom">
                <td class="main" width="75%">

                    <table border="0" cellspacing="0" cellpadding="0" width="100%">
                        <tr>
                            <td width="50%" style="padding-right: 10px">
                                <b><?php echo mh_lng('TABLE_HEADING_N2G_FIRSTNAME'); ?></b>
                                <br/>
                                <?php echo mh_draw_input_field('user_firstname', $user_firstname, 'size="50" style="width:100%"'); ?>
                                <br/></td>
                            <td width="50%" style="padding-left: 10px"><b><?php echo mh_lng('TABLE_HEADING_N2G_LASTNAME'); ?></b>
                                <br/>
                                <?php echo mh_draw_input_field('user_lastname', $user_lastname, 'size="50" style="width:100%;"'); ?>
                            </td>

                        </tr>
                    </table>


                </td>
            </tr>
            <tr valign="bottom">

                <td class="main" width="75%">
                </td>
            </tr>
            <tr valign="bottom">
                <td class="main" width="75%">

                    <table border="0" cellspacing="0" cellpadding="0" width="100%">
                        <tr>
                            <td width="50%" style="padding-right: 10px">
                                <b><?php echo mh_lng('TABLE_HEADING_N2G_EMAIL_ADDRESS'); ?></b> <br/>
                                <?php echo mh_draw_input_field('user_mail', $user_mail, 'size="50" style="width:100%"'); ?>
                                <br/>
                            </td>

                            <td width="50%" style="padding-left: 10px">
                                <b><?php echo mh_lng('TABLE_HEADING_N2G_SHOP_URL'); ?></b> <br/>
                                <?php echo mh_draw_input_field('shop_url', $shop_url, 'size="50" style="width:100%"'); ?>
                                <br/>
                            </td>

                        </tr>
                    </table>
                </td>
            </tr>
            <tr valign="bottom">
                <td class="main" width="75%">
                    <div style="float: left">
                        <input id="submit" type="submit" value="<?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_BUTTON'); ?>">

                    </div>
                    <div style="float: left; margin-top: 20px; margin-left: 20px">
                        <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_CONTACT'); ?>
                    </div>
                </td>
            </tr>


            <tr valign="bottom">
                <td class="main" width="75%">
                    <div style="padding-bottom: 20px"></div>
                    <div style="color: #909090">

                        <?php echo mh_lng('MAILBEEZ_CONFIG_EMAIL_ENGINE_N2G_REGISTER_NOTE'); ?>
                    </div>
                </td>
            </tr>

        </table>
    <?php
    }
    ?>

</div>
</form>

