<?php

/*
  MailBeez Automatic Trigger Email Campaigns
  http://www.mailbeez.com

  Copyright (c) 2010 - 2012 MailBeez

  inspired and in parts based on
  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  
  V2.7.4
 */

///////////////////////////////////////////////////////////////////////////////
///																																					 //
///                 MailBeez Core file - do not edit                         //
///                                                                          //
///////////////////////////////////////////////////////////////////////////////

require_once(MH_DIR_FS_CATALOG . MH_ROOT_PATH . 'common/classes/configbeez.php');

class config_gdpr_export extends configbeez
{

// class constructor
    function __construct()
    {
        parent::__construct();
        $this->code = 'config_gdpr_export';
        $this->module = 'config_gdpr_export'; // same as folder name
        $this->version = 4.1; // float value
        $this->title = mh_lng('MAILBEEZ_CONFIG_GDPR_EXPORT_TEXT_TITLE');
        $this->description = mh_lng('MAILBEEZ_CONFIG_GDPR_EXPORT_TEXT_DESCRIPTION');
        $this->description_image = '../../common/images/icon_system_64.png';
        $this->icon = '../../common/images/icon_system.png';
//        $this->removable = true; // can't be removed
//        $this->stealth = true; // don't list as an installed module
        $this->sort_order = 1000;
        $this->enabled = mh_cfg('MAILBEEZ_CONFIG_GDPR_EXPORT_STATUS') == 'True';
        $this->status_key = 'MAILBEEZ_CONFIG_GDPR_EXPORT_STATUS';
        $this->on_cfg_save_clear_template_c = true;

        $this->admin_action_plugins_path = MH_DIR_CONFIG; // default-path to include admin action plugins from
        $this->admin_action_plugins = '';

        $this->documentation_key = 'config_gdpr_export'; // leave empty if no documentation available
//        $this->documentation_root = 'https://www.mailbeez.com/documentation/installation/config/';
        $this->mlbz = true;

        // self installing
        if (!mh_cfg($this->status_key)) {
            $this->install();
        } else {
            $this->check_update();
        }
    }

// class methods


    // installation methods

    function keys()
    {

        $keys_array = array('MAILBEEZ_CONFIG_GDPR_EXPORT_STATUS', 'MAILBEEZ_CONFIG_GDPR_EXPORT_INCLUDE_STORE_DATA');

        return $keys_array;
    }

    function install()
    {
        mh_insert_config_value(array('configuration_title' => 'Activate GDPR Tools?',
            'configuration_key' => 'MAILBEEZ_CONFIG_GDPR_EXPORT_STATUS',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to activate the GDPR Tools Module?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));

        mh_insert_config_value(array('configuration_title' => 'Include store data?',
            'configuration_key' => 'MAILBEEZ_CONFIG_GDPR_EXPORT_INCLUDE_STORE_DATA',
            'configuration_value' => 'True',
            'configuration_description' => 'Do you want to include store data?',
            'set_function' => 'mh_cfg_select_option(array(\'True\', \'False\'), '
        ));
    }

}

